\name{psdList2NoiseMatrix}

\alias{psdList2NoiseMatrix}


\title{Apply instrument correction to PSDs}

\description{
The \code{psdList2NoiseMatrix} function uses the \code{snclq} identifier associated with the
first PSD in the list to obtain instrument correction information at the specified frequencies
from the \code{\link{getEvalresp}} web service if instrumentation correction information is
not supplied as an argument. This correction is applied to every PSD in 
the list and the now corrected PSD values are returned as a matrix. 
}

\usage{
psdList2NoiseMatrix(psdList, evalresp=NULL)
}

\arguments{
  \item{psdList}{a list of PSDs generated by the \code{psdList} function}
  \item{evalresp}{dataframe of freq, amp, phase information matching output of \code{getEvalresp}, optional}
}

%% \details{ }

\value{
A \code{matrix} is returned with one row for each instrument-corrected PSD and one column for each frequency bin.
}

\references{
\href{http://pubs.usgs.gov/of/2005/1438/pdf/OFR-1438.pdf}{Seismic Noise Analysis System Using Power Spectral Density Probability Density Functions} (McNamara and Boaz 2005)
}

\author{
Jonathan Callahan \email{jonathan@mazamascience.com}
}

\note{
The \code{psdList} function generates a \code{psdList} from a single \code{Stream} of data and should thus only 
contain data for a single SNCL (Station-Network-Channel-Location). However, the \code{psdList} is not checked to make sure that no changes to the
instrument correction happened during the time period covered by the \code{psdList}.  This occurs at an 'epoch'
boundary when an instrument is replaced.
}

\seealso{
\code{\link{McNamaraPSD}},
\code{\link{psdDF2NoiseMatrix}},
\code{\link{psdList}},
\code{\link{psdPlot}},
\code{\link{psdStatistics}},
}

\examples{
\dontrun{
# Create a new IrisClient
iris <- new("IrisClient", debug=TRUE)

# Get seismic data
starttime <- as.POSIXct("2011-05-05", tz="GMT") # 2011.125
endtime <- starttime + 1*24*3600
st <- getDataselect(iris,"IU","GRFO","--","BHE",starttime,endtime)

# Generate power spectral density for each hour long segment
psdList <- psdList(st)

# Convert into corrected "noiseMatrix"
noiseMatrix <- psdList2NoiseMatrix(psdList)

# Plot corrected PSDs
period <- 1/psdList[[1]]$freq
plot(period, noiseMatrix[1,], log='x', type='l',
     ylim=c(-200,-50),
     xlab="Period (Sec)", ylab="Power (dB)",
     main="Corrected PSDs")
     
for (i in seq(2:nrow(noiseMatrix))) {
  points(period, noiseMatrix[i,], type='l')
}
}
}

\keyword{spectra}
