/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.engine;

import cern.colt.Timer;
import cern.jet.random.tdouble.engine.DRand;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.random.tdouble.engine.MersenneTwister64;
import java.util.Random;

public class Benchmark {
    protected Benchmark() {
        throw new RuntimeException("Non instantiable");
    }

    public static void benchmark(int n) {
        Timer timer = new Timer();
        timer.reset().start();
        int n2 = n;
        while (--n2 >= 0) {
        }
        timer.stop().display();
        double d = timer.elapsedTime();
        System.out.println("empty loop timing done.");
        DoubleRandomEngine doubleRandomEngine = new DoubleMersenneTwister();
        System.out.println("\n MersenneTwister:");
        timer.reset().start();
        int n3 = n;
        while (--n3 >= 0) {
            doubleRandomEngine.raw();
        }
        timer.stop().display();
        System.out.println((double)n / (timer.elapsedTime() - d) + " numbers per second.");
        doubleRandomEngine = new MersenneTwister64();
        System.out.println("\n MersenneTwister64:");
        timer.reset().start();
        n3 = n;
        while (--n3 >= 0) {
            doubleRandomEngine.raw();
        }
        timer.stop().display();
        System.out.println((double)n / (timer.elapsedTime() - d) + " numbers per second.");
        doubleRandomEngine = new DRand();
        System.out.println("\nDRand:");
        timer.reset().start();
        n3 = n;
        while (--n3 >= 0) {
            doubleRandomEngine.raw();
        }
        timer.stop().display();
        System.out.println((double)n / (timer.elapsedTime() - d) + " numbers per second.");
        Random random = new Random();
        System.out.println("\njava.util.Random.nextFloat():");
        timer.reset().start();
        int n4 = n;
        while (--n4 >= 0) {
            random.nextFloat();
        }
        timer.stop().display();
        System.out.println((double)n / (timer.elapsedTime() - d) + " numbers per second.");
        System.out.println("\nGood bye.\n");
    }

    public static void main(String[] stringArray) {
        long l = Long.parseLong(stringArray[0]);
        long l2 = Long.parseLong(stringArray[1]);
        int n = Integer.parseInt(stringArray[2]);
        int n2 = Integer.parseInt(stringArray[3]);
        for (int i = 0; i < n2; ++i) {
            Benchmark.benchmark(n);
        }
    }

    public static void test(int n, DoubleRandomEngine doubleRandomEngine) {
        System.out.println("\n\nint():");
        DoubleRandomEngine doubleRandomEngine2 = (DoubleRandomEngine)doubleRandomEngine.clone();
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            System.out.print(" " + doubleRandomEngine2.nextInt());
            if (n2 % 8 == 7) {
                System.out.println();
            }
            ++n2;
        }
        System.out.println("\n\nGood bye.\n");
    }

    private static void xtestRandomFromTo(long l, long l2, int n) {
        System.out.println("from=" + l + ", to=" + l2);
        Random random = new Random();
        DoubleMersenneTwister doubleMersenneTwister = new DoubleMersenneTwister();
        int n2 = (int)l;
        int n3 = (int)l2;
        Timer timer = new Timer().start();
        int n4 = 0;
        int n5 = n;
        while (--n5 >= 0) {
            System.out.print(" " + doubleMersenneTwister.raw());
            if (n4 % 8 == 7) {
                System.out.println();
            }
            ++n4;
        }
        timer.stop().display();
        System.out.println("Good bye.\n");
    }
}

