/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;

public class SparseCCMLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseLongMatrix1D[] elements;

    public SparseCCMLongMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseLongMatrix1D[n2];
        for (int i = 0; i < n2; ++i) {
            this.elements[i] = new SparseLongMatrix1D(n);
        }
    }

    public SparseLongMatrix1D[] elements() {
        return this.elements;
    }

    public long getQuick(int n, int n2) {
        return this.elements[n2].getQuick(n);
    }

    public void setQuick(int n, int n2, long l) {
        this.elements[n2].setQuick(n, l);
    }

    public void trimToSize() {
        for (int i = 0; i < this.columns; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseLongMatrix1D viewColumn(int n) {
        return this.elements[n];
    }

    protected LongMatrix2D getContent() {
        return this;
    }

    public LongMatrix2D like(int n, int n2) {
        return new SparseCCMLongMatrix2D(n, n2);
    }
}

