% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ezMULTINOM}
\alias{ezMULTINOM}
\title{Calculates all pairwise contrasts and omnibus tests for multinomial regression}
\usage{
ezMULTINOM(formula, data, OR = TRUE, digits = 2L, pdigits = 3L)
}
\arguments{
\item{formula}{A standard regression formula, passed to
\code{vglm} from the \pkg{VGAM} package.}

\item{data}{A data frame (no other type currently supported)
to be used for model fitting.}

\item{OR}{a logical value whether to report odds ratios and
95 percent confidence intervals, if \code{TRUE}, or
regression coefficients on the logit scale with standard
errors, if \code{FALSE}.}

\item{digits}{An integer indicating the number of digits for coefficients,
standard errors, and confidence intervals}

\item{pdigits}{An integer indicating the number of digits for
p-values.}
}
\value{
A list with two elements.
  \code{Results} contains a data table of the actual estimates.
  \code{Table} contains a nicely formatted character matrix.
}
\description{
TODO: make me!
}
\examples{

\dontrun{
mtcars$cyl <- factor(mtcars$cyl)
mtcars$am <- factor(mtcars$am)

ezMULTINOM(cyl ~ qsec, data = mtcars)
ezMULTINOM(cyl ~ qsec, data = mtcars, digits = 4)$Table
ezMULTINOM(cyl ~ qsec, data = mtcars, OR = FALSE)
ezMULTINOM(cyl ~ qsec, data = mtcars, digits = 4, OR = FALSE)$Table

ezMULTINOM(cyl ~ scale(qsec), data = mtcars)

ezMULTINOM(cyl ~ factor(vs) * scale(qsec), data = mtcars)

## does not work in binary case, no need for the computational overhead
## ezMULTINOM(am ~ qsec, data = mtcars)

ezMULTINOM(Species ~ Sepal.Length, data = iris)
}
}
