/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.TaskManagement;

import java.util.Enumeration;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.TaskManagement.SimulationTask;
import org.omegahat.Environment.TaskManagement.Task;
import org.omegahat.Environment.TaskManagement.TaskManager;
import org.omegahat.Environment.TaskManagement.TaskQueue;

public class SimulationManager
extends TaskManager {
    public SimulationManager() {
    }

    public SimulationManager(int n) {
        super(n);
    }

    public synchronized void addVariable(String string, Object[] objectArray) {
        this.ensureTaskQueue(objectArray.length);
        TaskQueue taskQueue = this.tasks();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            SimulationTask simulationTask = (SimulationTask)taskQueue.elementAt(n);
            Database database = simulationTask.getDatabase();
            if (database == null) {
                database = simulationTask.setDatabase("Task " + n);
            }
            try {
                database.assign(string, object);
            }
            catch (Exception exception) {
                throw new RuntimeException("Couldn't assign \"" + string + "\" to task " + n + ": " + exception);
            }
            ++n;
        }
    }

    public void ensureTaskQueue(int n) {
        TaskQueue taskQueue = this.tasks();
        if (taskQueue == null || taskQueue.size() == 0) {
            taskQueue = new TaskQueue();
            int n2 = 0;
            while (n2 < n) {
                taskQueue.addTask(new SimulationTask());
                ++n2;
            }
            this.tasks(taskQueue);
        } else if (taskQueue.size() != n) {
            throw new IllegalArgumentException("Current task queue of length " + taskQueue.size() + " is incompatible with requested length of " + n);
        }
    }

    public Task getTask() {
        if (this.tasks().size() == 0) {
            return null;
        }
        return this.tasks().getTask();
    }

    public ExpressionInt setExpression(ExpressionInt expressionInt) {
        Enumeration enumeration = this.tasks().elements();
        while (enumeration.hasMoreElements()) {
            ((SimulationTask)enumeration.nextElement()).setExpression(expressionInt);
        }
        return expressionInt;
    }
}

