% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/P__disp.r
\name{P__disp}
\alias{P__disp}
\title{Display Pearson Chi2 and associated dispersion statistic
following following use of glm.}
\format{\describe{
\item{x}{
The only argument is the name of the fitted glm or glm.nb function model}
}}
\usage{
P__disp(x)
}
\arguments{
\item{x}{glm object}
}
\value{
\describe{
\item{Pearson Chi2}{Pearson Chi2 statistic}
\item{Dispersion}{Pearson dispersion: Chi2/dof}
%% ...
}
}
\description{
Following the glm() function with a grouped binomial or poisson family, or glm.nb(),
P__disp() displays the Pearson Chi2 statistic and related dispersion statistic.
Values of the dispersion greater than 1.0 indicate possible overdispersion; values
under 1.0 indicate possible underdispersion.
}
\details{
P_disp is a post-estimation function, following the use of glm() or glm.nb().
Appropriate with grouped binomial or Poisson glm families.
}
\note{
P__disp must be loaded into memory in order to be effectve. As a function in LOGIT,
it is immediately available to a user.
}
\examples{
library(MASS)
library(LOGIT)
data(titanicgrp)
class03 <- factor(titanicgrp$class, levels=c("3rd class", "2nd class", "1st class"))
died <- titanicgrp$cases - titanicgrp$survive
grptit <- glm( cbind(survive, died) ~ age+sex+class03, family=binomial,
data=titanicgrp)
summary(grptit)
P__disp(grptit)
}
\author{
Joseph M. Hilbe, Arizona State University, and
Jet Propulsion Laboratory, California Institute of technology
}
\references{
Hilbe, Joseph M. (2015), Practical Guide to Logistic Regression, Chapman & Hall/CRC.
Hilbe, Joseph M. (2014), Modeling Count Data, Cambridge University Press
}
\seealso{
\code{\link{glm}}
}
\keyword{models}

