% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/LSD.heatboxplot.R
\name{densitylane}
\alias{LSD.densitylane}
\alias{densitylane}
\title{Visualize a density in a rectangular fashion}
\usage{
densitylane(x, y, pos = 1, width = 0.4, colpal = "standard",
  rev = FALSE, simulate = FALSE, daltonize = FALSE, cvd = "p",
  alpha = NULL, horizontal = horizontal, nrcol = 75)
}
\arguments{
\item{x}{density$x values of a density object.}

\item{y}{density$y values of a density object.}

\item{pos}{the x co-ordinate of the lane (mid point).}

\item{width}{a numeric value giving the width of the lane.}

\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}) (defaults to "heat", if not specified).}

\item{rev}{logical: if \code{TRUE} (\code{FALSE} by default), a reversed colorpalette is used.}

\item{simulate}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{daltonize}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to enhance dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{horizontal}{logical: if \code{TRUE} (\code{FALSE} by default), rotation of 90 degrees is applied.}

\item{nrcol}{a non-negative integer specifying the number of colors to be used (defaults to 100, if not specified).}
}
\description{
Add a color stripe to an existing plot based on a kernel density estimate.
}
\author{
Bjoern Schwalb
}
\seealso{
\code{\link{comparisonplot}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\keyword{density}

