% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metab.ols.R
\name{metab.ols}
\alias{metab.ols}
\title{Metabolism model based on a ordinary least squares parameter estimation framework.}
\usage{
metab.ols(do.obs, do.sat, k.gas, z.mix, irr, wtr, ...)
}
\arguments{
\item{do.obs}{Vector of dissolved oxygen concentration observations, mg L^-1}

\item{do.sat}{Vector of dissolved oxygen saturation values based on water temperature. Calculate using \link{o2.at.sat}}

\item{k.gas}{Vector of kGAS values calculated from any of the gas flux models
(e.g., \link{k.cole}) and converted to kGAS using \link{k600.2.kGAS}}

\item{z.mix}{Vector of mixed-layer depths in meters. To calculate, see \link{ts.meta.depths}}

\item{irr}{Vector of photosynthetically active radiation in \eqn{\mu mol\ m^{-2} s^{-1}}{micro mols / m^2 / s}}

\item{wtr}{Vector of water temperatures in \eqn{^{\circ}C}{degrees C}. Used in scaling respiration with temperature}

\item{...}{additional arguments; currently "datetime" is the only recognized argument passed through \code{...}}
}
\value{
A data.frame with columns corresponding to components of metabolism
\describe{
\item{GPP}{numeric estimate of Gross Primary Production, \eqn{mg O_2 L^{-1} d^{-1}}{mg O2 / L / d}}
\item{R}{numeric estimate of Respiration, \eqn{mg O_2 L^{-1} d^{-1}}{mg O2 / L / d}}
\item{NEP}{numeric estimate of Net Ecosystem production, \eqn{mg O_2 L^{-1} d^{-1}}{mg O2 / L / d}}
}
}
\description{
This function runs the ordinary least squares metabolism model on the supplied gas concentration and other supporting data. This is a
common approach that allows for the concurrent estimation of metabolism paramters from a timeseries.
}
\examples{
library(rLakeAnalyzer)
doobs = load.ts(system.file('extdata',
                           'sparkling.doobs', package="LakeMetabolizer"))
wtr = load.ts(system.file('extdata',
                         'sparkling.wtr', package="LakeMetabolizer"))
wnd = load.ts(system.file('extdata',
                         'sparkling.wnd', package="LakeMetabolizer"))
irr = load.ts(system.file('extdata',
                         'sparkling.par', package="LakeMetabolizer"))

#Subset a day
mod.date = as.POSIXct('2009-07-08')
doobs = doobs[trunc(doobs$datetime, 'day') == mod.date, ]
wtr = wtr[trunc(wtr$datetime, 'day') == mod.date, ]
wnd = wnd[trunc(wnd$datetime, 'day') == mod.date, ]
irr = irr[trunc(irr$datetime, 'day') == mod.date, ]
z.mix = ts.thermo.depth(wtr)

k600 = k.cole.base(wnd[,2])
k.gas = k600.2.kGAS.base(k600, wtr[,3], 'O2')
do.sat = o2.at.sat.base(wtr[,3], altitude=300)

metab.ols(doobs[,2], do.sat, k.gas, z.mix[,2], irr[,2], wtr[,3])
}
\author{
Luke A Winslow, Ryan Batt, GLEON Fellows
}
\seealso{
\link{metab}, \link{metab.bookkeep}, \link{metab.mle}, \link{metab.kalman}, \link{metab.bayesian},
}

