% Generated by roxygen2 (4.0.2): do not edit by hand
\name{common-arguments}
\alias{common-arguments}
\title{Common arguments for many functions}
\arguments{
\item{y}{a numeric vector of real values (the observed data).}

\item{distname}{string; name of input distribution; see \code{\link{get_distnames}}.}

\item{type}{type of Lambert W \eqn{\times} F distribution: skewed \code{"s"};
heavy-tail \code{"h"}; or skewed heavy-tail \code{"hh"}.}

\item{theta}{list; a (possibly incomplete) list of parameters \code{alpha}, \code{beta}, \code{gamma},
\code{delta}. \code{\link{complete_theta}} fills in default values for missing entries.}

\item{beta}{vector; parameter \eqn{\boldsymbol \beta} of the input distribution.
See \code{\link{check_beta}} on how to specify \code{beta} for each distribution.}

\item{gamma}{scalar; skewness parameter; default: \code{0}.}

\item{delta}{scalar or vector (length 2); heavy-tail parameter(s); default: \code{0}.}

\item{alpha}{scalar or vector (length 2); heavy tail exponent(s); default: \code{1}.}

\item{tau}{named vector \eqn{\tau} which defines the variable transformation. Must have at least
\code{'mu_x'} and \code{'sigma_x'} element; see \code{\link{complete_tau}} for details.}

\item{return.u}{logical; if \code{TRUE}, the function returns the calculated output that corresponds
to \eqn{U}, which is the zero-mean and/or unit-variance version of input \eqn{X \sim F_X}.}
}
\description{
Useful reference list with most common function arguments in this package.
}

