% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_support}
\alias{get_support}
\title{Computes the truncated support for skewed Lambert W distributions}
\usage{
get_support(tau, is.non.negative = FALSE)
}
\arguments{
\item{tau}{named vector \eqn{\tau} which defines the variable transformation. Must have at least
\code{'mu_x'} and \code{'sigma_x'} element; see \code{\link{complete_tau}} for details.}

\item{is.non.negative}{logical; tell the penalty function if the data is from
a non-negative distribution;
by default it sets it to \code{TRUE} if the distribution is not a location but a scale family.
 If \code{TRUE}, the penalty can be computed; otherwise, it returns \code{NA}.}
}
\value{
A vector of length 2 with names \code{'lower'} and \code{'upper'}.
}
\description{
If the input \eqn{X \sim F} has support on the entire real line
\eqn{(-\infty, \infty)}, then the skewed Lambert W \eqn{\times} F
distribution has truncated support \eqn{[a,b]}, \eqn{a,b \in R \cup \pm
\infty} depending on \eqn{\boldsymbol \beta} and (the sign of) \eqn{\gamma}.
}
\details{
Half-open interval on the real line (if \eqn{\gamma \neq 0}) for
input with support on the entire real line. For \eqn{\gamma = 0} the support
of Y is the same as for X. Heavy-tail Lambert W RVs are not affected by
truncated support (since \eqn{\delta \geq 0} by definition); thus
support is \code{c(lower = -Inf, upper = Inf)}.
}
\examples{
get_support(c(mu_x = 0, sigma_x = 1, gamma = 0)) # as gamma = 0
# truncated on the left since gamma > 0
get_support(c(mu_x = 0, sigma_x = 1, gamma = 0.1))

# no truncation for heavy tail(s)
get_support(c(mu_x = 0, sigma_x = 1, delta = 0.1))
}
\keyword{math}

