% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_RLum.R
\name{set_RLum}
\alias{set_RLum}
\title{General set function for RLum S4 class objects}
\usage{
set_RLum(class, originator, .uid = .create_UID(), .pid = NA_character_, ...)
}
\arguments{
\item{class}{\code{\linkS4class{RLum}} (\bold{required}): name of the S4 class to
create}

\item{originator}{\code{\link{character}} (automatic): contains the name of the calling function
(the function that produces this object); can be set manually.}

\item{.uid}{\code{\link{character}} (automatic): sets an unique ID for this object
using the internal C++ function \code{.create_UID}.}

\item{.pid}{\code{\link{character}} (with default): option to provide a parent id for nesting
at will.}

\item{\dots}{further arguments that one might want to pass to the specific
set method}
}
\value{
Returns an object of the specified class.
}
\description{
Function calls object-specific set functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for specific
\code{\linkS4class{RLum}} objects.\cr Depending on the given class, the
corresponding method to create an object from this class will be selected.
Allowed additional arguments can be found in the documentations of the
corresponding \code{\linkS4class{RLum}} class: \code{\linkS4class{RLum.Data.Curve}},
\code{\linkS4class{RLum.Data.Image}}, \code{\linkS4class{RLum.Data.Spectrum}},
\code{\linkS4class{RLum.Analysis}} and \code{\linkS4class{RLum.Results}}
}
\section{Function version}{
 0.3.0 (2017-06-29 18:40:14)
}

\examples{

##produce empty objects from each class
set_RLum(class = "RLum.Data.Curve")
set_RLum(class = "RLum.Data.Spectrum")
set_RLum(class = "RLum.Data.Spectrum")
set_RLum(class = "RLum.Analysis")
set_RLum(class = "RLum.Results")

##produce a curve object with arbitrary curve values
object <- set_RLum(
class = "RLum.Data.Curve",
curveType = "arbitrary",
recordType = "OSL",
data = matrix(c(1:100,exp(-c(1:100))),ncol = 2))

##plot this curve object
plot_RLum(object)

}
\seealso{
\code{\linkS4class{RLum.Data.Curve}},
\code{\linkS4class{RLum.Data.Image}},
\code{\linkS4class{RLum.Data.Spectrum}},
\code{\linkS4class{RLum.Analysis}},
\code{\linkS4class{RLum.Results}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team} 

\section{How to cite}{
Kreutzer, S. (2017). set_RLum(): General set function for RLum S4 class objects. Function version 0.3.0. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.5. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
