% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MMOORA.R
\name{MMOORA}
\alias{MMOORA}
\title{Implementation of MULTIMOORA Method for Multi-Criteria Decision Making Problems.}
\usage{
MMOORA(decision, weights, cb)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x \emph{n}) with the values of the \emph{m} alternatives, for the \emph{n} criteria.}

\item{weights}{A vector of length \emph{n}, containing the weights for the criteria. The sum of the weights has to be 1.}

\item{cb}{A vector of length \emph{n}. Each component is either \code{cb(i)='max'} if the \emph{i-th} criterion is benefit or \code{cb(i)='min'} if the \emph{i-th} criterion is a cost.}
}
\value{
\code{MMOORA} returns a data frame which contains the scores and the four rankings calculated (Ratio System, Reference Point, Multiplicative Form and Multi-MOORA ranking).
}
\description{
The \code{MMOORA} function implements both the Multi-Objetive Optimization by Ration Analysis (MOORA) and the "Full Multiplicative Form" (MULTIMOORA).
}
\examples{
d <- matrix(rpois(12, 5), nrow = 4)
 w <- c(0.2, 0.2, 0.6)
 cb <- c('max','min','max')
 MMOORA(d,w,cb)
}
\references{
Brauers, W. K. M.; Zavadskas, E. K. Project management by MULTIMOORA as an instrument for transition economies. Technological and Economic Development of Economy, 16(1), 5-24, 2010.
}

