\name{createContinuousCovariates}
\alias{createContinuousCovariates}
\title{ Create a set of continuous covariates  }
\description{
  Creates a set of conntinuous covariates from a multivariate normal
 distribution and (optionally) a set of constraints.
}
\usage{
createContinuousCovariates(subjects, names, mean, covariance = 1, range = NULL, digits, 
  maxDraws = 100, seed = .deriveFromMasterSeed(), idCol = "SUBJ", includeIDCol = TRUE)

}
\arguments{
  \item{subjects}{ (Required) Subjects for which to create covariates                         }
  \item{names}{ (Required) Names for the continuous covariates.  They should be valid R names (See \code{\link{validNames}}) and no duplicate name should be given }
  \item{mean}{ (Required) Vector of means. Must be of same length as \code{names} }
  \item{covariance}{ (Optional) Covariance matrix - diagonal, lower triangle or full matrix. See \code{\link{parseCovMatrix}} for details.  1 by default }
  \item{range}{ (Optional) Ranges of acceptable values for each covariates. See \code{\link{parseRangeCode}} for details.  This is missing by default, resulting in no "range" limitation being applied }
  \item{digits}{ (Optional) Number of digits used to round the values.  This argument can be either missing (the default), so no rounding is done, of length one and all variables are rounded at the same digits, of same length than the number of covariates so that each covariate is rounded according to its value. This argument is first parsed by \code{\link{parseCharInput}} so it can either be a character vector or a numeric vector. See \code{\link{parseCharInput}}.  If the parsed \code{digits} vector does not have length one or length equal to the number of covariates, an error is generated by the \code{\link{ectdStop}} function.  This is missing by default, resulting in no rounding being performed }
  \item{maxDraws}{ (Optional) Maximum number of attempts allowed if initial data not in \code{range} (100 by default) } 
  \item{seed}{ (Optional) Random seed to use.  By default, this is derived from the current random seed } 
  \item{idCol}{ (Optional) Name of the subject column. Must be a valid R name (See \code{\link{validNames}}) and not equal to one entry of \code{names}.  "SUBJ" by default }
  \item{includeIDCol}{ (Optional) Should the subject column be included.  Typically only set to FALSE when called from \code{\link{createCovariates}}.  Defaults to TRUE }
}
\author{ Mango Solutions & Pfizer \email{mstoolkit@googlemail.com} }
\seealso{ 
\code{\link{createDiscreteCovariates}} to create covariates for a discrete distribution.

\code{\link{createExternalCovariates}} to create covariates by \emph{sampling} 
data from an external file.

\code{\link{createCovariates}} that wraps \code{createContinuousCovariates} and the 
two other described above.
}                       

\examples{
  # 30 samples from a :      [ 0 ]   [ 1, 0, 0 ]
  #                      N ( [ 0 ] , [ 0, 1, 0 ] )
  #                          [ 1 ]   [ 0, 0, 1 ] 
  dat <- createContinuousCovariates( 30, mean = "0,0,1", names = c("X", "Y", "Z")  )
  
  
  # 30 samples from a :      [ 0 ]   [ 1, 0, 0 ]
  #                      N ( [ 0 ] , [ 0, 1, 0 ] )
  #                          [ 1 ]   [ 0, 0, 1 ] 
  # truncated at X > 0
  dat <- createContinuousCovariates( 30, mean = "0,0,1", names = c("X", "Y", "Z"), 
     range= "X > 0"  )
  
  # 30 samples from a :      [ 0 ]   [ 1, 0, 0 ]
  #                      N ( [ 0 ] , [ 0, 1, 0 ] )
  #                          [ 1 ]   [ 0, 0, 1 ] 
  # truncated at X = 0, and X < Y  < 1
  dat <- createContinuousCovariates( 30, mean = "0,0,1", names = c("X", "Y", "Z"), 
     range= c("X > 0", "X< Y<1")  )
  stopifnot( all( dat$X < dat$Y ) )
  stopifnot( all( dat$X > 0 ) )
  
  # 30 samples from a :      [ 0 ]   [ 1 , .5, 0 ]
  #                      N ( [ 0 ] , [ .5, 1 , 0 ] )
  #                          [ 1 ]   [ 0 , 0 , 1 ] 
  dat1 <- createContinuousCovariates( 30, mean = "0,0,1", names = c("X", "Y", "Z"),
    covariance = "1,.5,1,0,0,1", seed = 30  )

  # same   
  dat2 <- createContinuousCovariates( 30, mean = "0,0,1", names = c("X", "Y", "Z"),
    covariance = cbind(c(1,.5,0), c(.5,1,0), c(0,0,1)) , seed = 30  )  
 
  stopifnot( all(dat1 == dat2 ))
  
  % tests added to comply with issue 3 of sourceforge
  % Tue Jul 24 09:08:08 BST 2007 @380 /Internet Time/

  # use of the digits argument
  # X will be rounded at 2 digits
  # Y will be rounded at 3 digits
  # Z will be rounded at 2 digits
  createContinuousCovariates( 10, mean = "100,100,100", 
    names = c("X", "Y", "Z"), digits = "2,3,2"  )
}
\keyword{ datagen }

