waldMMreg = function(target, dataset, xIndex, csIndex, wei = NULL, dataInfo = NULL, univariateModels=NULL , hash = FALSE, stat_hash = NULL, pvalue_hash = NULL, robust=FALSE) 
{
  #initialization
  #if the test cannot performed succesfully these are the returned values
  pvalue = log(1);
  stat = 0;
  flag = 0;
  csIndex[ which( is.na(csIndex) ) ] = 0;
  if (hash) {
    csIndex2 = csIndex[which(csIndex!=0)]
    csIndex2 = sort(csIndex2)
    xcs = c(xIndex,csIndex2)
    key = paste(as.character(xcs) , collapse=" ");
    if (is.null(stat_hash[[key]]) == FALSE)  {
      stat = stat_hash[[key]];
      pvalue = pvalue_hash[[key]];
      flag = 1;
      results <- list(pvalue = pvalue, stat = stat, flag = flag , stat_hash=stat_hash, pvalue_hash=pvalue_hash);
      return(results);
    }
  }
  #if the xIndex is contained in csIndex, x does not bring any new
  #information with respect to cs
  if ( !is.na(match(xIndex,csIndex)) ) {
    if (hash) {  #update hash objects
      stat_hash[[key]] <- 0;     #.set(stat_hash , key , 0)
      pvalue_hash[[key]] <- log(1);       #.set(pvalue_hash , key , 1)
    }
    results <- list(pvalue = log(1), stat = 0, flag = 1 , stat_hash=stat_hash, pvalue_hash=pvalue_hash);
    return(results);
  }
  #check input validity
  if (xIndex < 0 || csIndex < 0) {
    message(paste("error in testIndReg : wrong input of xIndex or csIndex"))
    results <- list(pvalue = pvalue, stat = stat, flag = flag , stat_hash=stat_hash, pvalue_hash=pvalue_hash);
    return(results);
  }
  xIndex = unique(xIndex);
  csIndex = unique(csIndex);
  #extract the data
  x = dataset[ , xIndex];
  cs = dataset[ , csIndex];
  n = length(target)
  #if x = any of the cs then pvalue = 1 and flag = 1.
  #That means that the x variable does not add more information to our model due to an exact copy of this in the cs, so it is independent from the target
  if ( length(cs) != 0 ) {
    if ( is.null(dim(cs)[2]) ) { #cs is a vector
      if (any(x != cs) == FALSE) { #if(!any(x == cs) == FALSE)
        if (hash) {  #update hash objects
          stat_hash[[key]] <- 0;#.set(stat_hash , key , 0)
          pvalue_hash[[key]] <- log(1);#.set(pvalue_hash , key , 1)
        }
        results <- list(pvalue = log(1), stat = 0, flag = 1 , stat_hash=stat_hash, pvalue_hash=pvalue_hash);
        return(results);
      }
    } else { #more than one var
      for ( col in 1:dim(cs)[2] ) {
        if (any(x != cs[,col]) == FALSE) {  #if(!any(x == cs) == FALSE)
          if (hash) { #update hash objects
            stat_hash[[key]] <- 0;#.set(stat_hash , key , 0)
            pvalue_hash[[key]] <- log(1);#.set(pvalue_hash , key , 1)
          }
          results <- list(pvalue = log(1), stat = 0, flag = 1 , stat_hash=stat_hash, pvalue_hash=pvalue_hash);
          return(results);
        }
      }
    }
  }
  #trycatch for dealing with errors
  res <- tryCatch(
    {
      #if the conditioning set (cs) is empty, we use a simplified formula
      if (length(cs) == 0) {
        fit = MASS::rlm(target ~ x, weights = wei, maxit = 2000, method = "MM")
      } else  fit = MASS::rlm(target ~ ., data = as.data.frame(dataset[, c(csIndex, xIndex)]), weights = wei, maxit = 2000, method = "MM")
      res = summary(fit)[[ 4 ]]
      pr = dim(res)[1]
      stat = res[pr, 3]^2
      pvalue = pchisq(stat, 1, lower.tail = FALSE, log.p = TRUE)
      flag = 1;
      #last error check
      if ( is.na(pvalue) || is.na(stat) ) {
        pvalue = log(1);
        stat = 0;
        flag = 0;
      } else {
        #update hash objects
        if (hash) {
          stat_hash[[key]] <- stat;        #.set(stat_hash , key , stat)
          pvalue_hash[[key]] <- pvalue;       #.set(pvalue_hash , key , pvalue)
        }
      }
      #testerrorcaseintrycatch(4);
      results <- list(pvalue = pvalue, stat = stat, flag = flag , stat_hash=stat_hash, pvalue_hash=pvalue_hash);
      return(results);
      
    },
    error=function(cond) {
      #   message(paste("warning in try catch of the testIndReg test"))
      #   message("Here's the original message:")
      #   message(cond)
      #          #for debug
      #          cat("\nxIndex = \n");
      #          cat(xIndex);
      #          cat("\ncsindex = \n");
      #          cat(csIndex);
      #   stop();
      #error case
      pvalue = log(1);
      stat = 0;
      flag = 1;
      results <- list(pvalue = pvalue, stat = stat, flag = flag , stat_hash=stat_hash, pvalue_hash=pvalue_hash);
      return(results);
    },
    finally={}
  )    
  return(res);
}