% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.r
\name{theta_vcov}
\alias{theta_vcov}
\title{Compute variance covariance of 'Unified' Second Moment}
\usage{
theta_vcov(X,vcov.func=vcov,fit.intercept=TRUE)
}
\arguments{
\item{X}{an \eqn{n \times p}{n x p} matrix of observed returns.}

\item{vcov.func}{a function which takes an object of class \code{lm},
and computes a variance-covariance matrix. If equal to the string
\code{"normal"}, we assume multivariate normal returns.}

\item{fit.intercept}{a boolean controlling whether we add a column
of ones to the data, or fit the raw uncentered second moment.
For now, must be true when assuming normal returns.}
}
\value{
a list containing the following components:
\item{mu}{a \eqn{q = (p+1)(p+2)/2} vector of 1, then the mean, 
then the vech'd second moment of the sample data.}
\item{Ohat}{the \eqn{q \times q}{q x q} estimated variance covariance 
matrix. When \code{fit.intercept} is true, the left column and top row
are all zeros.}
\item{n}{the number of rows in \code{X}.}
\item{pp}{the number of assets plus \code{as.numeric(fit.intercept)}.}
}
\description{
Computes the variance covariance matrix of sample mean and second moment.
}
\details{
Given \eqn{p}-vector \eqn{x}, the 'unified' sample is the 
\eqn{(p+1)(p+2)/2} vector of 1, \eqn{x}, and 
\eqn{\mbox{vech}(x x^{\top})}{vech(x x')} stacked on top
of each other.
Given \eqn{n} contemporaneous observations of \eqn{p}-vectors,
stacked as rows in the \eqn{n \times p}{n x p} matrix \eqn{X},
this function computes the mean and the variance-covariance
matrix of the 'unified' sample. 

One may use the default method for computing covariance,
via the \code{\link{vcov}} function, or via a 'fancy' estimator,
like \code{sandwich:vcovHAC}, \code{sandwich:vcovHC}, \emph{etc.}
}
\note{
Replaces similar functionality from SharpeR package, but with 
modified API.
}
\examples{
X <- matrix(rnorm(1000*3),ncol=3)
Sigmas <- theta_vcov(X)
Sigmas.n <- theta_vcov(X,vcov.func="normal")
Sigmas.n <- theta_vcov(X,fit.intercept=FALSE)

# make it fat tailed:
X <- matrix(rt(1000*3,df=5),ncol=3)
Sigmas <- theta_vcov(X)
\dontrun{
if (require(sandwich)) {
 Sigmas <- theta_vcov(X,vcov.func=vcovHC)
}
}
# add some autocorrelation to X
Xf <- filter(X,c(0.2),"recursive")
colnames(Xf) <- colnames(X)
Sigmas <- theta_vcov(Xf)
\dontrun{
if (require(sandwich)) {
Sigmas <- theta_vcov(Xf,vcov.func=vcovHAC)
}
}

}
\references{
Pav, S. E. "Asymptotic Distribution of the Markowitz Portfolio."
2013 \url{http://arxiv.org/abs/1312.0557}

Pav, S. E. "Portfolio Inference with this One Weird Trick."
R in Finance, 2014 \url{http://past.rinfinance.com/agenda/2014/talk/StevenPav.pdf}
}
\seealso{
\code{\link{itheta_vcov}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{univar}
