% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Matrix.utils.R
\name{rBind.fill}
\alias{rBind.fill}
\title{Combine matrixes by row, fill in missing columns}
\usage{
rBind.fill(x, ..., fill = NA)
}
\arguments{
\item{x, ...}{Objects to combine.  If the first argument is a list and 
\code{..} is unpopulated, the objects in that list will be combined.}

\item{fill}{value with which to fill unmatched columns}
}
\value{
a single object of the same class as the first input, or of class
  \code{matrix} if the first object is one dimensional
}
\description{
rbinds a list of Matrix or matrix like objects, filling in missing columns.
}
\details{
Similar to \code{\link[plyr]{rbind.fill.matrix}}, but works for
\code{\link{Matrix}} as well as all other R objects.  It is completely
agnostic to class, and will produce an object of the class of the first input
(or of class \code{matrix} if the first object is one dimensional).

The implementation is recursive, so it can handle an arbitrary number of 
inputs, albeit inefficiently for large numbers of inputs.

This method is still experimental, but should work in most cases.  If the
data sets consist solely of data frames, \code{\link[plyr]{rbind.fill}} is 
preferred.
}
\examples{
df1 = data.frame(x = c(1,2,3), y = c(4,5,6))
rownames(df1) = c("a", "b", "c")
df2 = data.frame(x = c(7,8), z = c(9,10))
rownames(df2) = c("a", "d")
rBind.fill(df1,df2,fill=NA)
rBind.fill(as(df1,'Matrix'),df2,fill=0)
rBind.fill(as.matrix(df1),as(df2,'Matrix'),c(1,2),fill=0)
rBind.fill(c(1,2,3),list(4,5,6,7))
rBind.fill(df1,c(1,2,3,4))

m<-rsparsematrix(1000000,100,.001)
m2<-m
colnames(m)<-1:100
colnames(m2)<-3:102
system.time(b<-rBind.fill(m,m2))

}
\seealso{
\code{\link[plyr]{rbind.fill}}

\code{\link[plyr]{rbind.fill.matrix}}
}

