\name{CsparseMatrix-class}
\docType{class}
\alias{CsparseMatrix-class}
\alias{\%*\%,CsparseMatrix,CsparseMatrix-method}
\alias{\%*\%,CsparseMatrix,ddenseMatrix-method}
\alias{\%*\%,CsparseMatrix,matrix-method}
\alias{\%*\%,CsparseMatrix,numeric-method}
\alias{\%*\%,ddenseMatrix,CsparseMatrix-method}
\alias{\%*\%,matrix,CsparseMatrix-method}
\alias{\%*\%,numeric,CsparseMatrix-method}
\alias{coerce,CsparseMatrix,lsparseMatrix-method}
\alias{coerce,CsparseMatrix,TsparseMatrix-method}
\alias{coerce,CsparseMatrix,denseMatrix-method}
\alias{coerce,CsparseMatrix,matrix-method}
\alias{coerce,matrix,CsparseMatrix-method}
\alias{coerce,numeric,CsparseMatrix-method}
\alias{crossprod,CsparseMatrix,missing-method}
\alias{crossprod,CsparseMatrix,ddenseMatrix-method}
\alias{crossprod,CsparseMatrix,matrix-method}
\alias{crossprod,CsparseMatrix,numeric-method}
\alias{diag,CsparseMatrix-method}
\alias{t,CsparseMatrix-method}
\alias{tcrossprod,CsparseMatrix,missing-method}
\alias{colMeans,CsparseMatrix-method}
\alias{colSums,CsparseMatrix-method}
\alias{rowMeans,CsparseMatrix-method}
\alias{rowSums,CsparseMatrix-method}
%% Group methods --------- FIXME: not tested yet (or documented)
\alias{Arith,CsparseMatrix,CsparseMatrix-method}
\alias{Arith,CsparseMatrix,numeric-method}
\alias{Arith,numeric,CsparseMatrix-method}
\alias{Math,CsparseMatrix-method}
%
\title{Class "CsparseMatrix" of Sparse Matrices in Column-compressed Form}
\description{The \code{"CsparseMatrix"} class is the virtual class of
  all sparse matrices coded in sorted compressed column-oriented form.
  Since it is a virtual class, no objects may be created from it.  See
  \code{showClass("CsparseMatrix")} for its subclasses.
}

\section{Slots}{
  \describe{
    \item{\code{i}:}{Object of class \code{"integer"} of length nnzero
      (number of non-zero elements).  These are the \emph{0-based} row numbers for
      each non-zero element in the matrix, i.e., \code{i} must be in
      \code{0:(nrow(.)-1)}}.
    \item{\code{p}:}{Object of class \code{"integer"} for providing pointers, one
      for each column, to the initial (zero-based) index of elements in
      the column.  \code{.@p} is of length \code{ncol(.) + 1}, with
      \code{p[1] == 0} and \code{p[length(p)] == nnzero}, such that in
      fact, \code{diff(.@p + 1)} are the number of non-zero elements for
      each column.}
    \item{\code{factors}, \code{Dim}, \code{Dimnames}:}{inherited from
      the superclass, see the \code{\linkS4class{sparseMatrix}} class.}
  }
}
\section{Extends}{
Class \code{"sparseMatrix"}, directly.
Class \code{"Matrix"}, by class \code{"sparseMatrix"}.
}
\section{Methods}{
  \describe{%% The following is generated by promptClass(..) --
    %% FIXME: write a script that update all the *-class.Rd files
    \item{Arith}{\code{signature(e1 = "CsparseMatrix", e2 = "numeric")}: ... }
    \item{Arith}{\code{signature(e1 = "numeric", e2 = "CsparseMatrix")}: ... }
    \item{Math}{\code{signature(x = "CsparseMatrix")}: ... }

    \item{band}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{-}{\code{signature(e1 = "CsparseMatrix", e2 = "numeric")}: ... }
    \item{-}{\code{signature(e1 = "numeric", e2 = "CsparseMatrix")}: ... }
    \item{[<-}{\code{signature(x = "CsparseMatrix", i = "index", j = "missing", value = "replValue")}: ... }
    \item{[<-}{\code{signature(x = "CsparseMatrix", i = "index", j = "index", value = "replValue")}: ... }
    \item{[<-}{\code{signature(x = "CsparseMatrix", i = "missing", j = "index", value = "replValue")}: ... }
    \item{\%*\%}{\code{signature(x = "CsparseMatrix", y = "CsparseMatrix")}: ... }
    \item{\%*\%}{\code{signature(x = "CsparseMatrix", y = "denseMatrix")}: ... }
    \item{\%*\%}{\code{signature(x = "CsparseMatrix", y = "matrix")}: ... }
    \item{+}{\code{signature(e1 = "CsparseMatrix", e2 = "numeric")}: ... }
    \item{+}{\code{signature(e1 = "numeric", e2 = "CsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "CsparseMatrix", to = "TsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "CsparseMatrix", to = "denseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "CsparseMatrix", to = "matrix")}: ... }
    \item{coerce}{\code{signature(from = "CsparseMatrix", to = "lsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "TsparseMatrix", to = "CsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "denseMatrix", to = "CsparseMatrix")}: ... }
    \item{colMeans}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{colSums}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{crossprod}{\code{signature(x = "CsparseMatrix", y = "missing")}: ... }
    \item{crossprod}{\code{signature(x = "CsparseMatrix", y = "dgeMatrix")}: ... }
    \item{crossprod}{\code{signature(x = "CsparseMatrix", y = "matrix")}: ... }
    \item{diag}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{gamma}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{lgamma}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{log}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{rowMeans}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{rowSums}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{t}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{tcrossprod}{\code{signature(x = "CsparseMatrix", y = "missing")}: ... }
    \item{tril}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{triu}{\code{signature(x = "CsparseMatrix")}: ... }
  }
}
\seealso{
  its superclass, \code{\linkS4class{sparseMatrix}}, and, e.g.,
  class \code{\linkS4class{dgCMatrix}} for the links to other classes.
}
\examples{
showClass("CsparseMatrix")
}
\keyword{classes}
