% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getCountryName.R
\name{getCountryName}
\alias{getCountryName}
\title{Return Countriy Names at Specified Locations}
\usage{
getCountryName(lon, lat, dataset = "SimpleCountries", countryCodes = NULL,
  allData = FALSE)
}
\arguments{
\item{lon}{Vector of longitudes in decimal degrees}

\item{lat}{Vector of latitudes in decimal degrees}

\item{dataset}{name of spatial dataset to use -- defaults to 'SimpleCountries'}

\item{countryCodes}{vector of countryCodes -- defaults to \code{NULL}}

\item{allData}{logical specifying whether a full dataframe should be returned}
}
\value{
vector of English country names
}
\description{
Uses spatial comparison to determine which country polygons the
    locations fall into and returns the country name and country code
    strings for those polygons.

    If \code{allData=TRUE} additional data is returned.
}
\examples{
lon <- seq(0,50)
lat <- seq(0,50)
getCountry(lon,lat)
}
\references{
\url{http://www.naturalearthdata.com/downloads/10m-cultural-vectors/}
}
\seealso{
SimpleCountries

getSpatialData
}
\keyword{spatial}

