% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ClusterModelNames.R
\name{clusterGammaNames}
\alias{clusterGammaNames}
\alias{clusterValidGammaNames}
\title{Build a vector of gamma model names.}
\usage{
clusterGammaNames(prop = "all", shapeInCluster = "all",
  shapeBetweenCluster = "free", scaleInCluster = "all",
  scaleBetweenCluster = "all")

clusterValidGammaNames(names)
}
\arguments{
\item{prop}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{shapeInCluster}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{shapeBetweenCluster}{A character string equal to "equal", "free" or "all". Default is "free".}

\item{scaleInCluster}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{scaleBetweenCluster}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{names}{a vector of character}
}
\value{
A vector of character with the model names.
}
\description{
In a gamma model, we can assume that the shapes are equal in each/all
cluster(s) or not. We can also assume that the scales are equal in each/all
cluster(s) or not.

check if a vector of gamma model name is correct.
}
\details{
Some configuration are impossibles. If the shapes are equal between all the
clusters, then the scales cannot be equal between all the clusters. Conversely
if the scales are equal between all the cluster, then the shapes cannot be equal
between all the clusters.

This gives rise to 24 models:
\enumerate{
 \item {The proportions can be equal or free.}
 \item {The shapes can be equal or free in each clusters.}
 \item {The shapes can be equal or free between all clusters.}
 \item {The scales can be equal or free for each clusters.}
 \item {The scales can be equal or free between all clusters.}
}

The model names are summarized in the following array:
\tabular{lllll}{
         &  ajk                &  ak            &  aj            &  a \\
bjk       & gamma_*_ajk_bjk     & gamma_*_ak_bjk & gamma_*_aj_bjk & gamma_*_a_bjk \\
bk        & gamma_*_ajk_bk      & gamma_*_ak_bk  & gamma_*_aj_bk  & gamma_*_a_bk \\
bj        & gamma_*_ajk_bj      & gamma_*_ak_bj  & NA             & NA  \\
b         & gamma_*_ajk_b       & gamma_*_ak_b   & NA             & NA \\
}
}
\examples{
clusterGammaNames()
## same as c("gamma_p_ak_bj", "gamma_pk_ak_bj")
clusterGammaNames("all", "equal", "free", "free", "equal")
}
\keyword{internal}

