% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-domesticplotters.R
\name{conf_ell}
\alias{conf_ell}
\title{Confidence ellipses}
\usage{
conf_ell(x, y, conf = 0.95, nb.pts = 60)
}
\arguments{
\item{x}{numeric values on the x axis}

\item{y}{numeric values on the y axis}

\item{conf}{the level of confidence}

\item{nb.pts}{the number of points to return, to draw the ellipsis}
}
\value{
a list with $ell coordinates of the ellipse and $seg coordinates
of its vertices

a matrix of (x; y) coordinates to draw the ellipsis
}
\description{
Draw (gaussian) confidence ellipses
}
\examples{
x <- rnorm(100, sd=3)
y <- rnorm(100)
plot(x, y, asp=1)
ce095 <- conf_ell(x, y, conf=0.95) # no need for conf arg since it's .95 by default
ce090 <- conf_ell(x, y, conf=0.90)
ce050 <- conf_ell(x, y, conf=0.50)
cols <- col_hot(10)
lines(ce050$ell, col=cols[5]) # you can also coo_close(ce050$ell)
lines(ce090$ell, col=cols[8])
lines(ce095$ell, col=cols[9])
segments(ce095$seg[1, 1], ce095$seg[1, 2], ce095$seg[2, 1], ce095$seg[2, 2])
segments(ce095$seg[3, 1], ce095$seg[3, 2], ce095$seg[4, 1], ce095$seg[4, 2])
}
\seealso{
Other plotting functions: \code{\link{Ntable}},
  \code{\link{coo_arrows}}, \code{\link{coo_draw}},
  \code{\link{coo_listpanel}}, \code{\link{coo_lolli}},
  \code{\link{coo_plot}}, \code{\link{coo_ruban}},
  \code{\link{ldk_chull}}, \code{\link{ldk_confell}},
  \code{\link{ldk_contour}}, \code{\link{ldk_labels}},
  \code{\link{ldk_links}}, \code{\link{plot_devsegments}}
}

