% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{ppa}
\alias{ppa}
\title{Posterior probability of association function}
\usage{
ppa(p = 0.05, prior = 0.5, BF = NULL, quiet = TRUE)
}
\arguments{
\item{p}{p-value you want to test [p<0.367], or 'bayes factor'}

\item{prior}{prior odds for the hypothesis (Ha) being tested}

\item{BF}{logical, set to TRUE if you have entered a bayes factor
as 'p' rather than a p-value}

\item{quiet}{logical, whether to display verbose information for
calculation}
}
\value{
prints calculations, then returns the posterior 
probability of association given the observed p-value 
under the specified prior
}
\description{
Estimate the probability of your hypothesis being true,
given the observed p-value and a prior probability of
the hypothesis being true.
}
\examples{
ps <- rep(c(.05,.01),3)
prs <- rep(c(.05,.50,.90),each=2)
mapply(ps,prs,FUN=ppa)  # replicate Nuzzo 2014 table
# try with bayes factors
ppa(BF=3,prior=.9)
ppa(BF=10,prior=.5)
}
\references{
Equations 1, 2 from
http://www.readcube.com/articles/10.1038/nrg2615
Equations 2, 3 from
http://www.tandfonline.com/doi/pdf/10.1198/000313001300339950
}

