% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectivity.r
\name{connectivity}
\alias{connectivity}
\title{Connectivity}
\usage{
connectivity(NET, Lowercase = 1, col.1 = 1, col.2 = 2, col.score = 3,
  echo = 1, main = "Connectivity plot", min.score = NA, n.top = NA,
  hex = FALSE)
}
\arguments{
\item{NET}{Input network file.}

\item{Lowercase}{If node IDs should be rendered lower-case (Default:1, i.e. 'yes').}

\item{col.1}{Number of column where 1st node of each edge should be found (only needed when NET is a text file rather than a list).}

\item{col.2}{Number of column where 2nd node of each edge should be found (only needed when NET is a text file rather than a list, i.e. passed down to import.net).}

\item{col.score}{Number of column  where edge confidence score is found (only needed when NET is a text file rather than a list, i.e. passed down to import.net).}

\item{echo}{If messages about execution progress should appear.}

\item{main}{title name for the plot, default: "Connectivity plot"}

\item{min.score}{Minimum confidence score for an edge to be included in the network (is alternative to n.top and is only used when NET is a text file rather than a list, i.e. passed down to import.net).}

\item{n.top}{Number of edges to be included in the network, top when ranked by confidence score (is alternative to min.score and only used when NET is a text file rather than a list, i.e. passed down to import.net).}

\item{hex}{If the node degree distribution should be presented as density plot using package hexbin.}
}
\description{
Function for plotting node degree distribution in order to test if the network is scale-free
}
\examples{
file <-  system.file("extdata", "Connectivity.FC1_full", package = "NEArender")
\donttest{
connect <- connectivity(file,hex=TRUE)
}
}
\seealso{
\code{\link{benchmark}} and \code{\link{import.net}}
}
