% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARMA.R
\name{VN.ARMA}
\alias{VN.ARMA}
\title{VN ARMA}
\usage{
VN.ARMA(variable, h = 1, Training_set = NULL, Seasonal_Factor = TRUE,
  Negative_Values = FALSE, Linear = TRUE, Dynamic = FALSE)
}
\arguments{
\item{variable}{Variable}

\item{h}{Number of periods to forecast, defaults to 1.}

\item{Training_set}{Sets the number of observations from 1:xx to monitor performance of forecast over in-sample range. Defaults to NULL to use all observations.}

\item{Seasonal_Factor}{Automatically selects the best seasonal lag from the seasonality test.  Defaults to TRUE.  To use weighted average of all seasonal lags set to FALSE.}

\item{Negative_Values}{If the variable can be negative, set to TRUE.  Defaults to FALSE.}

\item{Linear}{To use a linear regression of the component series, defaults to TRUE.  To use a nonlineaer regression, set to FALSE.}

\item{Dynamic}{To update the seasonal factor with each forecast point, set to TRUE.  The default is FALSE to keep the original seasonal factor from the inputted variable for all forecasts.}
}
\description{
Autoregressive model incorporating nonlinear regressions of component series.
}
\examples{
set.seed(123)
x<-rnorm(100)
\dontrun{VN.ARMA(x)}
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{Autoressive}
\keyword{model}

