% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSD.R
\name{NNS.FSD}
\alias{NNS.FSD}
\title{NNS FSD Test}
\usage{
NNS.FSD(x, y)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}
}
\value{
Returns one of the following FSD results: \code{"X FSD Y"}, \code{"Y FSD X"}, or \code{"NO FSD EXISTS"}.
}
\description{
Bi-directional test of first degree stochastic dominance using lower partial moments.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
NNS.FSD(x,y)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2016) "LPM Density Functions for the Computation of the SD Efficient Set." Journal of Mathematical Finance, 6, 105-126. \url{http://www.scirp.org/Journal/PaperInformation.aspx?PaperID=63817}.
}
\keyword{dominance}
\keyword{stochastic}

