% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Co_PM_dep.R
\name{NNS.dep.hd}
\alias{NNS.dep.hd}
\title{NNS Co-Partial Moments Higher Dimension Dependence}
\usage{
NNS.dep.hd(x, plot = FALSE, independence.overlay = FALSE)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{plot}{logical; \code{FALSE} (default) Generates a 3d scatter plot with regression points using \link{plot3d}.}

\item{independence.overlay}{logical; \code{FALSE} (default) Creates and overlays independent \link{Co.LPM} and \link{Co.UPM} regions to visually reference the difference in dependence from the data.frame of variables being analyzed.  Under independence, the light green and red shaded areas would be occupied by green and red data points respectively.}
}
\value{
\itemize{
\item{$actual.observations} Number of \link{Co.LPM} and \link{Co.UPM} observations.
\item{$independent.null} Expected number of \link{Co.LPM} and \link{Co.UPM} observations under the null hypothesis of independence.
\item{$Dependence} Multivariate nonlinear dependence coefficient [0,1]
}
}
\description{
Determines higher dimension dependence coefficients based on degree 0 co-partial moments.
}
\examples{
set.seed(123)
x <- rnorm(1000) ; y <- rnorm(1000) ; z <- rnorm(1000)
A <- data.frame(x, y, z)
NNS.dep.hd(A, plot = TRUE, independence.overlay = TRUE)
}
\references{
Viole, F. (2016) "Beyond Correlation: Using the Elements of Variance for Conditional Means and Probabilities"  \url{https://www.ssrn.com/abstract=2745308}.
}
\author{
Fred Viole, OVVO Financial Systems
}
