% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimHensonRT.r
\name{opiInitialise_for_SimHensonRT}
\alias{opiInitialise_for_SimHensonRT}
\title{opiInitialise_for_SimHensonRT}
\arguments{
\item{type}{A single character that is:
\itemize{
\item \code{N} for using the A and B values from the Normals in Henson et al (2000)
\item \code{G} for using the A and B values from the Glaucomas in Henson et al (2000)
\item \code{C} for using the A and B values from the Combined in Henson et al (2000)
\item \code{X} to specify your own A and B values as parameters
}}

\item{A}{Coefficient of \code{t} in the formula (ignored if \code{type != 'X'}).}

\item{B}{Addend of \code{t} in the formula (ignored if \code{type != 'X'}).}

\item{cap}{Maximum dB value for the stdev of the FoS curve.}

\item{maxStim}{The maximum stimulus value (0 dB) in cd/\eqn{\mbox{m}^2}{m^2}.}

\item{rtData}{A data.frame with colnames == "Rt", "Dist", "Person" (or NULL for default).}

\item{rtFP}{A response time for false positives ??? for "SimHensonRT"}

\item{...}{Any other parameters you like, they are ignored.}
}
\value{
A list with elements:
\itemize{
\item \code{err} NULL if initialised, string msg otherwise
}
}
\description{
Simulates responses using a Frequency of Seeing (FoS) curve.

For internal use only, use \code{opiInitialize()}.

The FoS is modelled as a cumulative Gaussian function over dB with
standard deviation equal to \code{min(cap, exp( A * t + B))}, where
t is the threshold/mean of the FoS in dB.
All values are in dB relative to \code{maxStim}.
}
\details{
If the chosen OPI implementation is \code{SimHensonRT}, then the first six
parameters are as in \code{SimHenson}, and \code{rtData} is a data frame
with at least 2 columns: \code{"Rt"}, response time; and \code{"Dist"},
signifying that distance between assumed threshold and stimulus value in
your units.

This package contains \code{RtSigmaUnits} or \code{RtDbUnits} that can be
loaded with the commands \code{data(RtSigmaUnits)} or \code{data(RtDbUnits)},
and are suitable to pass as values for \code{rtData}.

\code{rtFp} gives the vector of values in milliseconds from which a response
time for a false positive response is randomly sampled.
}
\examples{
# Set up a simple simulation for white-on-white perimetry
# and display the stimuli in a plot region and simulate response times
chooseOpi("SimHensonRT")
data(RtSigmaUnits)
oi <- opiInitialize(type="C", cap=6, display=NA, rtData=RtSigmaUnits, rtFP=1:100)
if (!is.null(oi$err))
  stop("opiInitialize failed")

    # Set up a simple simulation for white-on-white perimetry
chooseOpi("SimHenson")
res <- opiInitialize(type = "C", cap = 6)
if (!is.null(res$err))
  stop(paste("opiInitialize() failed:", res$err))

}
