% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkLL.R
\name{checkLL}
\alias{checkLL}
\title{lat-long coordinate check}
\usage{
checkLL(lat, long, data, fun = stop, trace = TRUE, ...)
}
\arguments{
\item{lat, long}{Latitude (North/South) and longitude (East/West) coordinates in decimal degrees}

\item{data}{Optional: data.frame with the columns \code{lat} and \code{long}}

\item{fun}{One of the functions \code{\link{stop}}, \code{\link{warning}},
or \code{\link{message}}. DEFAULT: stop}

\item{trace}{Logical: Add function call stack to the message? DEFAULT: TRUE
WARNING: in do.call settings with large objects
(like \code{map} in \code{\link{scaleBar}}),
tracing may take a lot of computing time.}

\item{\dots}{Further arguments passed to \code{fun}}
}
\value{
Invisible T/F vector showing which of the coordinates is violated
        in the order: minlat, maxlat, minlong, maxlong.
        Only returned if check is passed or fun != stop
}
\description{
check lat-long coordinates for plausibility
}
\examples{
checkLL(lat=52, long=130)
checkLL(130, 52, fun=message)
checkLL(85:95, 0, fun=message)

d <- data.frame(x=0, y=0)
checkLL(y,x, d)

\dontrun{
checkLL(85:95, 0, fun="message")
checkLL(170,35) # throws an informative error
checkLL(85:95, 0, trace=FALSE)
}

mustfail <- function(expr) stopifnot(berryFunctions::is.error(expr))
mustfail( checkLL(100)         )
mustfail( checkLL(100, 200)    )
mustfail( checkLL(-100, 200)   )
mustfail( checkLL(90.000001, 0)   )

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Aug 2016
}
\seealso{
\code{\link{pointsMap}}, \code{\link{putm}},
         \code{berryFunctions::\link[berryFunctions]{checkFile}}
}

