% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MxCompute.R
\name{mxComputeConfidenceInterval}
\alias{MxComputeConfidenceInterval-class}
\alias{mxComputeConfidenceInterval}
\title{Find likelihood-based confidence intervals}
\usage{
mxComputeConfidenceInterval(plan, ..., freeSet = NA_character_,
  verbose = 0L, engine = NULL, fitfunction = "fitfunction",
  tolerance = NA_real_, constraintType = "ineq")
}
\arguments{
\item{plan}{compute plan to optimize the model}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{freeSet}{names of matrices containing free variables}

\item{verbose}{level of debugging output}

\item{engine}{deprecated}

\item{fitfunction}{The deviance function to constrain with an inequality constraint.}

\item{tolerance}{deprecated}

\item{constraintType}{one of c('ineq', 'eq', 'both', 'none')}
}
\description{
There are various ways to pose an equivalent profile likelihood
problem. For good performance, it is essential to tailor the
problem to the abilities of the optimizer. The problem can be
posed without the use of constraints. This is how the code worked
in version 2.1 and prior. Although this way of posing the problem
creates an ill-conditioned Hessian, NPSOL is somehow able to
isolate the poor conditioning from the rest of the problem and
optimize it quickly. However, SLSQP is not so clever and exhibits
very poor performance. For SLSQP, good performance is contingent
on posing the problem using an inequality constraint on the fit.
}
\details{
Geometrically, SLSQP performs best on smooth likelihood surfaces
with smooth derivatives. In the profile CI problem, the distance
limit on the deviance is like a wall. Walls do not have smooth
derivatives but are more like a step function. The point of
\link{mxConstraint} is to isolate the parts of a problem that are
geometrically non-smooth. Constraints are dealt with specially in
SLSQP to best accommodate their sharp geometry.

For the default compute plan, the choice of constraintType is
determined by which optimizer is selected.
}
\references{
Pek, J. & Wu, H. (in press). Profile likelihood-based confidence intervals and regions for structural equation models.
\emph{Psychometrica.}
}

