% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.r
\name{matches}
\alias{matches}
\title{Number of matches in ratings}
\usage{
matches(x, deviation = 0, diag.na = TRUE)
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{deviation}{Maximal difference between ratings to be considered a match
(default \code{0} = only identical rating scores are a match). Especially useful
for long rating scale (e.g. 0 to 100).}

\item{diag.na}{Whether to set the diagonal of the matrices to \code{NA} (default
is \code{TRUE}).}
}
\value{
A list of class \code{org.matches} with:
\itemize{
\item \code{grid}: The grid used to calculate the matches.
\item \code{deviation} The deviation parameter.
\item \code{max_constructs} Maximum possible number of matches across constructs.
\item \code{max_elements} Maximum possible number of matches across elements.
\item \code{total_constructs} Total number of matches across constructs.
\item \code{total_elements} Total number of matches across elements.
\item \code{constructs}: Matrix with no. of matches for constructs.
\item \code{elements}: Matrix with no. of matches for elements.
}
}
\description{
Count the number of matches, i.e. (near) identical ratings between two
elements or constructs. Matches are used as the basis for the calculation of
grid indexes.
}
\examples{
m <- matches(boeker)

# several output options
print(m, index = FALSE, names = FALSE, upper = FALSE)
print(m, output = "C")  # construct matches
print(m, output = "E")  # element matches

# extract the matrices
m$constructs
m$elements

}
