% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.r
\name{indexPvaff}
\alias{indexPvaff}
\title{Percentage of Variance Accounted for by the First Factor (PVAFF)}
\usage{
indexPvaff(x, method = 1)
}
\arguments{
\item{x}{\code{repgrid} object.}

\item{method}{Method to compute PVAFF: \code{1} = PCA is applied to raw data with centered constructs (default), \code{2} =
SVD of construct correlation matrix.}
}
\description{
The PVAFF is used as a measure of cognitive complexity. It was introduced in an unpublished PhD thesis by Jones
(1954, cit. Bonarius, 1965). To calculate it, the 'first factor' two different methods may be used. One applies
principal component analysis (PCA) to the construct centered raw data (default), the second applies SVD to the
construct correlation matrix. The PVAFF reflects the amount of variation that is accounted for by a single linear
component. If a single latent component is able to explain the variation in the grid, the cognitive complexity is
said to be low. In this case the construct system is regarded as 'simple' (Bell, 2003).
}
\examples{

indexPvaff(bell2010)

}
\references{
Bell, R. C. (2003). An evaluation of indices used to represent construct structure. In G. Chiari & M.
L. Nuzzo (Eds.), \emph{Psychological Constructivism and the Social World} (pp. 297-305). Milan: FrancoAngeli.

Bonarius, J. C. J. (1965). Research in the personal construct theory of George A. Kelly: role construct repertory
test and basic theory. In B. A. Maher (Ed.),
\emph{Progress in experimental personality research}
(Vol. 2). New York: Academic Press.

James, R. E. (1954). \emph{Identification in terms of personal constructs} (Unpublished doctoral thesis). Ohio State
University, Columbus, OH.
}
