% Generated by roxygen2 (4.0.2): do not edit by hand
\name{biplotPseudo3d}
\alias{biplotPseudo3d}
\title{See \code{\link{biplotPseudo3d}} for its use.
Draws a biplot of the grid in 2D with depth impression (pseudo 3D).}
\usage{
biplotPseudo3d(x, dim = 1:2, map.dim = 3, e.point.col = c("white",
  "black"), e.point.cex = c(0.6, 1.2), e.label.col = c("white", "black"),
  e.label.cex = c(0.6, 0.8), e.color.map = c(0.4, 1),
  c.point.col = c("white", "darkred"), c.point.cex = c(0.6, 1.2),
  c.label.col = c("white", "darkred"), c.label.cex = c(0.6, 0.8),
  c.color.map = c(0.4, 1), ...)
}
\arguments{
\item{x}{\code{repgrid} object.}

\item{dim}{Dimensions (i.e. principal components) to be used for biplot
(default is \code{c(1,2)}).}

\item{map.dim}{Third dimension (depth) used to map aesthetic attributes to
(default is \code{3}).}

\item{e.point.col}{Color(s) of the element symbols. Two values can be entered that will
create a color ramp. The values of \code{map.dim} are mapped onto the ramp.
The default is \code{c("white", "black")}. If only one color color value
is supplied (e.g. \code{"black"}) no mapping occurs and all elements
will have the same color irrespective of their value on the \code{map.dim}
dimension.}

\item{e.point.cex}{Size of the element symbols. Two values can be entered that will
represents the lower and upper size of a range of cex the values of \code{map.dim}
are mapped onto. The default is \code{c(.6, 1.2)}. If only one cex value
is supplied (e.g. \code{.7}) no mapping occurs and all elements
will have the same size irrespective of their value on the \code{map.dim}
dimension.}

\item{e.label.col}{Color(s) of the element labels. Two values can be entered that will
create a color ramp. The values of \code{map.dim} are mapped onto the ramp.
The default is \code{c("white", "black")}. If only one color color value
is supplied (e.g. \code{"black"}) no mapping occurs and all element labels
will have the same color irrespective of their value on the \code{map.dim}
dimension.}

\item{e.label.cex}{Size of the element labels. Two values can be entered that will
represents the lower and upper size of a range of cex the values of \code{map.dim}
are mapped onto. The default is \code{c(.6, .8)}. If only one cex value
is supplied (e.g. \code{.7}) no mapping occurs and all element labels
will have the same size irrespective of their value on the \code{map.dim}
dimension.}

\item{e.color.map}{Value range to determine what range of the color ramp defined in
\code{e.color} will be used for mapping the colors.
Default is \code{c(.4, ,1)}. Usually not important for the user.}

\item{c.point.col}{Color(s) of the construct symbols. Two values can be entered that will
create a color ramp. The values of \code{map.dim} are mapped onto the ramp.
The default is \code{c("white", "darkred")}. If only one color color value
is supplied (e.g. \code{"black"}) no mapping occurs and all elements
will have the same color irrespective of their value on the \code{map.dim}
dimension.}

\item{c.point.cex}{Size of the construct symbols. Two values can be entered that will
represents the lower and upper size of a range of cex the values of \code{map.dim}
are mapped onto. The default is \code{c(.6, 1.2)}. If only one cex value
is supplied (e.g. \code{.7}) no mapping occurs and all elements
will have the same size irrespective of their value on the \code{map.dim}
dimension.}

\item{c.label.col}{Color(s) of the construct labels. Two values can be entered that will
create a color ramp. The values of \code{map.dim} are mapped onto the ramp.
The default is \code{c("white", "black")}. If only one color color value
is supplied (e.g. \code{"black"}) no mapping occurs and all construct labels
will have the same color irrespective of their value on the \code{map.dim}
dimension.}

\item{c.label.cex}{Size of the construct labels. Two values can be entered that will
represents the lower and upper size of a range of cex the values of \code{map.dim}
are mapped onto. The default is \code{c(.6, .9)}. If only one cex value
is supplied (e.g. \code{.7}) no mapping occurs and all construct labels
will have the same size irrespective of their value on the \code{map.dim}
dimension.}

\item{c.color.map}{Value range to determine what range of the color ramp defined in
\code{c.color} will be used for mapping. Default is \code{c(.4, ,1)}.
Usually not important for the user.}

\item{...}{Additional parameters passed to \code{\link{biplot2d}}.}
}
\description{
This version is basically a 2D biplot.
It only modifies color and size of the symbols in order to create a 3D impression
of the data points.
This function will call the standard \code{\link{biplot2d}} function with some
modified arguments. For the whole set of arguments that can be used
see \code{\link{biplot2d}}. Here only the arguments special to
\code{biplotPseudo3d} are outlined.
}
\examples{
\dontrun{
   # biplot with 3D impression
   biplotPseudo3d(boeker)
   # Slater's biplot with 3D impression
   biplotPseudo3d(boeker, g=1, h=1, center=1)

   # show 2nd and 3rd dim. and map 4th
   biplotPseudo3d(boeker, dim=2:3, map.dim=4)

   # change elem. colors
   biplotPseudo3d(boeker, e.color=c("white", "darkgreen"))
   # change con. colors
   biplotPseudo3d(boeker, c.color=c("white", "darkgreen"))
   # change color mapping range
   biplotPseudo3d(boeker, c.colors.map=c(0, 1))

   # set uniform con. text size
   biplotPseudo3d(boeker, c.cex=1)
   # change text size mapping range
   biplotPseudo3d(boeker, c.cex=c(.4, 1.2))
}
}
\author{
Mark Heckmann
}
\seealso{
Unsophisticated biplot: \code{\link{biplotSimple}}; \cr
           2D biplots:
           \code{\link{biplot2d}},
           \code{\link{biplotEsa2d}},
           \code{\link{biplotSlater2d}};\cr
           Pseudo 3D biplots:
           \code{\link{biplotPseudo3d}},
           \code{\link{biplotEsaPseudo3d}},
           \code{\link{biplotSlaterPseudo3d}};\cr
           Interactive 3D biplots:
           \code{\link{biplot3d}},
           \code{\link{biplotEsa3d}},
           \code{\link{biplotSlater3d}};\cr
           Function to set view in 3D:
           \code{\link{home}}.
}

