% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.R
\name{corr}
\alias{corr}
\title{Calculates the weighted correlation given a data set and a set of weights.}
\usage{
corr(d, w = rep(1, nrow(d))/nrow(d))
}
\arguments{
\item{d}{a matrix with two columns corresponding to the two variables whose correlation we wish to calculate.}

\item{w}{a vector of weights to be applied to each pair of observations. The default is equal weights for each pair. Normalization takes place within the function so sum(w) need not equal 1.}
}
\value{
the correlation coefficient between d[,1] and d[,2].
}
\description{
This is a copy of corr function from the boot package. It calculates the correlation coefficient in weighted form.
}
\keyword{correlation}

