% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{lmm.theta}
\alias{lmm.theta}
\title{MLE for theta - Mallows Model}
\usage{
lmm.theta(sample, sigma_0 = identity.permutation(dim(sample)[2]),
  dist.name = "kendall", disk = FALSE)
}
\arguments{
\item{sample}{the matrix with the permutations to estimate}

\item{sigma_0}{optional the consensus permutation. If not given it is assumed to be the identity permutation}

\item{dist.name}{optional the name of the distance used by the model. One of: kendall (default), cayley, hamming, ulam}

\item{disk}{optional can only be true if estimating a MM under the Ulam distance.
Insted of generating the whole set of SYT and count of permutations per distance, it loads the info from a file in the disk}
}
\value{
The MLE for the dispersion parameter
}
\description{
Compute the MLE for the dispersion parameter (theta) given a sample of n permutations
and a central permutation
}
\examples{
sample <- matrix(c(1,2,3,4, 1,4,3,2, 1,2,4,3), nrow = 3, ncol = 4, byrow = TRUE)
lmm.theta(sample, dist.name="kendall")
lmm.theta(sample, dist.name="cayley")
lmm.theta(sample, dist.name="cayley", sigma_0=c(1,4,3,2))
lmm.theta(sample, dist.name="hamming")
lmm.theta(sample, dist.name="ulam")
}

