% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.conflictmat.R
\name{as.conflictmat}
\alias{as.conflictmat}
\title{convert to a matrix of \code{conf.mat} class}
\usage{
as.conflictmat(Data, weighted = FALSE, swap.order = FALSE)
}
\arguments{
\item{Data}{either a dataframe or a matrix, representing raw win-loss interactions using either an edgelist or a matrix. 
By default, winners are represented by IDs in the 1st column for an edgelist, and by row IDs for a matrix. 
Frequency of interactions for each dyad can be represented either by multiple occurrences of the dyad for a 2-column edgelist, or
by a third column specifying the frequency of the interaction for a 3-column edgelist.}

\item{weighted}{If the edgelist is a 3-column edgelist in which weight was specified by frequency, use \code{weighted = TRUE}.}

\item{swap.order}{If the winner is placed in the 2nd column for an edgelist or as the column name for a matrix, specify as \code{TRUE}. By default, winners are placed in the first column of an edgelist or in the row names of a matrix.}
}
\value{
a named matrix with the \code{[i,j]}th entry equal to the number of times \code{i} wins over \code{j}.
}
\description{
\code{as.conflictmat} convert an edgelist or a win-loss raw matrix to a matrix of \code{conf.mat} class
}
\details{
\code{conf.mat} is short for "Conflict Matrix". \code{conf.mat} is 
a class of R objects. It is required to use \code{as.conflictmat} to convert your
raw edgelist or raw win-loss matrix into a matrix of \code{conf.mat} object before
using other functions to find (in)direct pathways and computing dominance probabilities.

Note, when using a 3-column edgelist (e.g. a weighted edgelist) to represent raw win-loss interactions, each dyad must be unique. If more than one rows are found with the same initiator and recipient,
sum of the frequencies will be taken to represent the freqency of interactions between this unique dyad. A warning message will prompt your attention to the accuracy of your raw data when duplicate dyads were found in a three-column edgelist.
}
\examples{
confmatrix <- as.conflictmat(sampleEdgelist, swap.order = FALSE)
confmatrix2 <- as.conflictmat(sampleRawMatrix, swap.order = FALSE)
confmatrix3 <- as.conflictmat(sampleWeightedEdgelist, weighted = TRUE, swap.order = FALSE)
}
\seealso{
\code{\link{findIDpaths}}, \code{\link{countPaths}}, \code{\link{transitivity}}, \code{\link{conductance}}
}

