/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.operator;

import org.openfast.Global;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.template.Scalar;
import org.openfast.template.TwinValue;
import org.openfast.template.operator.AlwaysPresentOperatorCodec;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;
import org.openfast.util.Util;

final class DeltaStringOperatorCodec
extends AlwaysPresentOperatorCodec {
    private static final long serialVersionUID = 1L;

    DeltaStringOperatorCodec() {
        super(Operator.DELTA, new Type[]{Type.ASCII, Type.STRING, Type.UNICODE, Type.BYTE_VECTOR});
    }

    public ScalarValue getValueToEncode(ScalarValue value, ScalarValue priorValue, Scalar field) {
        if (value == null) {
            return ScalarValue.NULL;
        }
        if (priorValue == null) {
            Global.handleError(FastConstants.D6_MNDTRY_FIELD_NOT_PRESENT, "The field " + field + " must have a priorValue defined.");
            return null;
        }
        ScalarValue base = priorValue.isUndefined() ? field.getBaseValue() : priorValue;
        return Util.getDifference(value.getBytes(), base.getBytes());
    }

    public ScalarValue decodeValue(ScalarValue newValue, ScalarValue previousValue, Scalar field) {
        ScalarValue base;
        if (newValue == null || newValue.isNull()) {
            return null;
        }
        TwinValue diffValue = (TwinValue)newValue;
        ScalarValue scalarValue = base = previousValue.isUndefined() ? field.getBaseValue() : previousValue;
        if (diffValue.first.toInt() > base.toString().length()) {
            Global.handleError(FastConstants.D7_SUBTRCTN_LEN_LONG, "The string diff <" + diffValue + "> cannot be applied to the base value \"" + base + "\" because the subtraction length is too long.");
        }
        byte[] bytes = Util.applyDifference(base, diffValue);
        return field.getType().getValue(bytes);
    }

    public ScalarValue decodeEmptyValue(ScalarValue previousValue, Scalar field) {
        throw new IllegalStateException("As of FAST v1.1 Delta values must be present in stream");
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

