/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.openfast.ByteVectorValue;
import org.openfast.ScalarValue;
import org.openfast.StringValue;
import org.openfast.error.FastConstants;
import org.openfast.error.FastException;
import org.openfast.template.type.codec.NotStopBitEncodedTypeCodec;
import org.openfast.template.type.codec.TypeCodec;

final class NullableUnicodeString
extends NotStopBitEncodedTypeCodec {
    private static final long serialVersionUID = 1L;

    NullableUnicodeString() {
    }

    public byte[] encodeValue(ScalarValue value) {
        if (value.isNull()) {
            return TypeCodec.NULLABLE_BYTE_VECTOR_TYPE.encodeValue(ScalarValue.NULL);
        }
        try {
            byte[] utf8encoding = ((StringValue)value).value.getBytes("UTF8");
            return TypeCodec.NULLABLE_BYTE_VECTOR_TYPE.encode(new ByteVectorValue(utf8encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new FastException("Apparently Unicode is no longer supported by Java.", FastConstants.IMPOSSIBLE_EXCEPTION, e);
        }
    }

    public ScalarValue decode(InputStream in) {
        ScalarValue decodedValue = TypeCodec.NULLABLE_BYTE_VECTOR_TYPE.decode(in);
        if (decodedValue == null) {
            return null;
        }
        ByteVectorValue value = (ByteVectorValue)decodedValue;
        try {
            return new StringValue(new String(value.value, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new FastException("Apparently Unicode is no longer supported by Java.", FastConstants.IMPOSSIBLE_EXCEPTION, e);
        }
    }

    public ScalarValue fromString(String value) {
        return new StringValue(value);
    }

    public ScalarValue getDefaultValue() {
        return new StringValue("");
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

