/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.model;

import gnu.trove.list.array.TIntArrayList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class PriceDataSet {
    private final byte[] timeSec;
    private final byte[] price;
    private final int[] priceValueMissing;
    private final int[] priceIndexMissing;
    private final int[] timeSecValueMissing;
    private final int[] timeSecIndexMissing;
    private int iniPrice;
    private int iniTimeSec;
    private final int numberTimeSteps;

    public double[] getPrice() {
        double[] realPrice = new double[this.price.length];
        long priceValue = this.iniPrice;
        int missingCount = 0;
        int i = 0;
        while (i < this.price.length) {
            if (this.priceIndexMissing[missingCount] == i) {
                priceValue = this.priceValueMissing[missingCount++];
            }
            double value = priceValue += (long)this.price[i];
            realPrice[i] = value * 0.01;
            ++i;
        }
        return realPrice;
    }

    public int[] getTimeSec() {
        int[] realTimeSec = new int[this.timeSec.length];
        int timeSecValue = this.iniTimeSec;
        int missingCount = 0;
        int i = 0;
        while (i < this.timeSec.length) {
            if (this.timeSecIndexMissing[missingCount] == i) {
                timeSecValue = this.timeSecValueMissing[missingCount++];
            }
            realTimeSec[i] = timeSecValue += this.timeSec[i];
            ++i;
        }
        return realTimeSec;
    }

    public int[] getTimeNanoSec() {
        int[] realTimeNanoSec = new int[this.timeSec.length];
        return realTimeNanoSec;
    }

    public PriceDataSet(double[] price, int[] timeSeconds) throws Exception {
        int diff;
        int i;
        int[] timeSec;
        this.numberTimeSteps = price.length;
        TIntArrayList priceValueMissing = new TIntArrayList();
        TIntArrayList priceIndexMissing = new TIntArrayList();
        TIntArrayList timeSecValueMissing = new TIntArrayList();
        TIntArrayList timeSecIndexMissing = new TIntArrayList();
        int[] frequensy = new int[128];
        if (timeSeconds.length != price.length && timeSeconds.length != 0) {
            throw new Exception("Length of price and time vector must be the same.");
        }
        if (timeSeconds.length == 0) {
            timeSec = new int[price.length];
            i = 0;
            while (i < price.length) {
                timeSec[i] = i + 1;
                ++i;
            }
        } else {
            timeSec = timeSeconds;
        }
        this.price = new byte[price.length];
        this.timeSec = new byte[timeSec.length];
        this.price[0] = 0;
        this.iniPrice = (int)(price[0] * 100.0);
        i = 1;
        while (i < price.length) {
            diff = (int)(price[i] * 100.0) - (int)(price[i - 1] * 100.0);
            if (Math.abs(diff) <= 127) {
                this.price[i] = (byte)diff;
                int j = 0;
                while (j <= Math.abs(diff)) {
                    int n = j++;
                    frequensy[n] = frequensy[n] + 1;
                }
            } else {
                this.price[i] = 0;
                priceValueMissing.add((int)(price[i] * 100.0));
                priceIndexMissing.add(i);
            }
            ++i;
        }
        this.timeSec[0] = 0;
        this.iniTimeSec = timeSec[0];
        i = 1;
        while (i < timeSec.length) {
            diff = timeSec[i] - timeSec[i - 1];
            if (diff <= 0) {
                throw new Exception(String.format("\nWrong time data: in time[%s], time[i-1] must be less then time[i]", "" + i));
            }
            if (Math.abs(diff) <= 127) {
                this.timeSec[i] = (byte)diff;
            } else {
                this.timeSec[i] = 0;
                timeSecValueMissing.add(timeSec[i]);
                timeSecIndexMissing.add(i);
            }
            ++i;
        }
        priceValueMissing.add(-1);
        priceIndexMissing.add(-1);
        timeSecValueMissing.add(-1);
        timeSecIndexMissing.add(-1);
        this.priceValueMissing = priceValueMissing.toArray();
        this.priceIndexMissing = priceIndexMissing.toArray();
        this.timeSecValueMissing = timeSecValueMissing.toArray();
        this.timeSecIndexMissing = timeSecIndexMissing.toArray();
    }

    public int getNumberTimeSteps() {
        return this.numberTimeSteps;
    }

    public byte[] toBinaryZipCompress() {
        byte[] yourBytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            GZIPOutputStream gzos = new GZIPOutputStream(bos){
                {
                    this.def.setLevel(9);
                }
            };
            out = new ObjectOutputStream(gzos);
            out.writeObject(this);
            out.flush();
            gzos.finish();
            yourBytes = bos.toByteArray();
            out.close();
            bos.close();
            return yourBytes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static PriceDataSet fromBinaryZip(byte[] yourBytes) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(yourBytes);
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(bis));
            Object result = in.readObject();
            bis.close();
            in.close();
            return (PriceDataSet)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

