/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.differential;

public final class Delta {
    public static void delta(int[] data) {
        for (int i = data.length - 1; i > 0; --i) {
            int n = i;
            data[n] = data[n] - data[i - 1];
        }
    }

    public static int delta(int[] data, int start, int length, int init) {
        int nextinit = data[start + length - 1];
        for (int i = length - 1; i > 0; --i) {
            int n = start + i;
            data[n] = data[n] - data[start + i - 1];
        }
        int n = start;
        data[n] = data[n] - init;
        return nextinit;
    }

    public static int delta(int[] data, int start, int length, int init, int[] out) {
        for (int i = length - 1; i > 0; --i) {
            out[i] = data[start + i] - data[start + i - 1];
        }
        out[0] = data[start] - init;
        return data[start + length - 1];
    }

    public static void inverseDelta(int[] data) {
        for (int i = 1; i < data.length; ++i) {
            int n = i;
            data[n] = data[n] + data[i - 1];
        }
    }

    public static void fastinverseDelta(int[] data) {
        int i;
        int sz0 = data.length / 4 * 4;
        if (sz0 >= 4) {
            int a = data[0];
            for (i = 1; i < sz0 - 4; i += 4) {
                int n = i;
                int n2 = data[n] + a;
                data[n] = n2;
                a = n2;
                int n3 = i + 1;
                int n4 = data[n3] + a;
                data[n3] = n4;
                a = n4;
                int n5 = i + 2;
                int n6 = data[n5] + a;
                data[n5] = n6;
                a = n6;
                int n7 = i + 3;
                int n8 = data[n7] + a;
                data[n7] = n8;
                a = n8;
            }
        }
        while (i != data.length) {
            int n = i;
            data[n] = data[n] + data[i - 1];
            ++i;
        }
    }

    public static int fastinverseDelta(int[] data, int start, int length, int init) {
        int i;
        int n = start;
        data[n] = data[n] + init;
        int sz0 = length / 4 * 4;
        if (sz0 >= 4) {
            int a = data[start];
            for (i = 1; i < sz0 - 4; i += 4) {
                int n2 = start + i;
                int n3 = data[n2] + a;
                data[n2] = n3;
                a = n3;
                int n4 = start + i + 1;
                int n5 = data[n4] + a;
                data[n4] = n5;
                a = n5;
                int n6 = start + i + 2;
                int n7 = data[n6] + a;
                data[n6] = n7;
                a = n7;
                int n8 = start + i + 3;
                int n9 = data[n8] + a;
                data[n8] = n9;
                a = n9;
            }
        }
        while (i != length) {
            int n10 = start + i;
            data[n10] = data[n10] + data[start + i - 1];
            ++i;
        }
        return data[start + length - 1];
    }
}

