many.pval <- function(stat.indices, law.index, n = 100, M = 10^5, N = 100, alter = create.alter(stat.indices), law.pars = NULL, parstats = NULL, null.dist = 2, method = c("direct","MC")) {

  if(getRversion() < "3.1") dontCheck <- identity

  method <- match.arg(method)
  nbstats <- length(stat.indices)
	
  if (!is.null(parstats)) {
    if (!is.list(parstats)) stop("'parstats' should be a named list")
  }
		
  if (!is.list(alter)) stop("'alter' should be a named list")
  if (!all(alter %in% 0:4)) stop("'alter' should take values in {0,1,2,3,4}!")
  stats.index <- as.numeric(sub("stat","",names(alter)))
  if (!(any(stats.index %in% stat.indices))) stop("Indices of statistic in 'stat.indices' and 'alter' should match!")

  if (!is.null(law.pars)) {    
    nblaw.pars <- length(law.pars)
    if (nblaw.pars > 4) stop("The maximum number of law parameters is 4. Contact the package author to increase the value!")
  }

  nbparstatsvec <- rep(NA,nbstats)
  for (i in 1:nbstats) {nbparstatsvec[i] <- length(parstats[[i]])}        
  
### when method is "direct", we check if any of p-values is NA. If yes we stop and suggest to change to "MC" method.
  if (method == "direct") {
    
    for (i in 1:nbstats) {
      xtmp <- rnorm(10)
      # call .C function to obtain a p-value
      Cstat.name <- paste("stat",stat.indices[i],sep="")
      pvaluetmp <- (.C(dontCheck(Cstat.name),as.double(xtmp),as.integer(length(xtmp)),0.05,
                          1L,rep(" ",50),0L,statistic=0.0,pvalcomp=1L,pvalue=0.0,cL=0.0,
                          cR=0.0,0L,alter=3L,decision=0L,
                          paramstat=0.0,nbparamstat=0L,PACKAGE="PoweR"))$pvalue
      if (pvaluetmp == 0L) stop("No direct method exists to compute test statistic (",stat.indices[i],")'s p-value. You should use MC method instead!")
    }
	
    matrix.pval <- matrix(.C("matrixpval",as.integer(N),as.integer(law.index),as.integer(n),
                             nbparams=as.integer(length(law.pars)),as.double(law.pars),as.integer(stat.indices),
                             as.integer(nbstats),as.integer(unlist(alter)),as.double(unlist(parstats)),
                             as.integer(nbparstatsvec),res=as.double(rep(0.0,N*nbstats)),DUP=FALSE,
                             PACKAGE="PoweR")$res,nrow=N,ncol=nbstats)
  }

### MC method
  if (method == "MC") {
    
    matrix.pval <- matrix(.C("matrixpvalMC",as.integer(n),law=as.integer(null.dist),as.integer(nbstats),
                             as.integer(M),as.integer(stat.indices),as.integer(nbparstatsvec),as.double(unlist(parstats)),
                             funclist=list(function(){}),as.integer(N),as.integer(law.index),
                             nbparams=as.integer(length(law.pars)),as.integer(unlist(alter)),as.double(unlist(parstats)),
                             as.integer(nbparstatsvec),res=as.double(rep(0,N*nbstats)),PACKAGE="PoweR")$res,nrow=N,ncol=nbstats)
  }
  
  ## set names for rows and columns of matrix.pval
  colnames(matrix.pval) <- c(getindex()$mat.stats[stat.indices,2])
  rownames(matrix.pval)[1:N] <- law.cstr(law.index,law.pars)$name
	
  return(list(pvals=matrix.pval,stat.indices=stat.indices,n=n,M=M,alter=alter,parstats=parstats,null.dist=null.dist,method=method))

}
