% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{set.par.ps}
\alias{set.par.ps}
\title{Define the model coefficients of a geostatistical linear model with preferentially sampled locations}
\usage{
set.par.ps(p = 1, q = 1, intensity, response, preferentiality.par)
}
\arguments{
\item{p}{number of covariates used in the response variable model, including the intercept. Default is \code{p=1}.}

\item{q}{number of covariates used in the log-Guassian Cox process model, including the intercept. Default is \code{q=1}.}

\item{intensity}{a vector of parameters of the log-Gaussian Cox process model. These must be provided in the following order: regression coefficients of the explanatory variables; variance and scale of the spatial correlation for the isotropic Gaussian process.
In the case of a model with a mix of preferentially and non-preferentially sampled locations, the order of the regression coefficients should be the following: regression coefficients for the linear predictor with preferential sampling; regression coefficients for the linear predictor with non-preferential samples.}

\item{response}{a vector of parameters of the response variable model. These must be provided in the following order: regression coefficients of the explanatory variables; variance and scale of the spatial correlation for the isotropic Gaussian process; and variance of the nugget effect.}

\item{preferentiality.par}{value of the preferentiality paramter.}
}
\value{
a list of coefficients of class \code{coef.PrevMap.ps}.
}
\description{
\code{set.par.ps} defines the model coefficients of a geostatistical linear model with preferentially sampled locations.
The output of this function can be used to: 1) define the parameters of the importance sampling distribution in \code{\link{lm.ps.MCML}}; 2) the starting values of the optimization algorithm in \code{\link{lm.ps.MCML}}.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}
}
