% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{sampleLength}
\alias{sampleLength}
\alias{sampleLength,PTSample-method}
\title{Get the length of a PTSample}
\usage{
\S4method{sampleLength}{PTSample}(sample)
}
\arguments{
\item{sample}{A \code{PTSample} object for which the length needs to be returned.}
}
\value{
Returns a \code{numeric} value representing the number of samples
(bytes) the \code{PTSample} object \code{sample} is composed of.
}
\description{
Gets the length (in samples = bytes) of an audio fragment stored as a
\code{\link{PTSample}}.
}
\details{
\code{\link{PTSample}}s are 8 bit mono audio fragments. This method
returns the length of this fragment expressed as number of samples (which
also equals the number of bytes).
}
\examples{
data("mod.intro")

## Show the length of the second sample in mod.intro
sampleLength(PTSample(mod.intro, 2))
}
\author{
Pepijn de Vries
}
\seealso{
Other sample.operations: \code{\link{PTSample,PTModule,numeric-method}},
  \code{\link{PTSample,Wave,missing-method}},
  \code{\link{PTSample,raw,missing-method}},
  \code{\link{PTSample-method}}, \code{\link{PTSample<-}},
  \code{\link{PTSample<-,PTModule,numeric,PTSample-method}};
  \code{\link{PTSample}}, \code{\link{PTSample-class}};
  \code{\link{fineTune}},
  \code{\link{fineTune,PTSample-method}},
  \code{\link{fineTune<-}},
  \code{\link{fineTune<-,PTSample,numeric-method}};
  \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopSample}},
  \code{\link{loopSample,PTSample-method}};
  \code{\link{loopStart}},
  \code{\link{loopStart,PTSample-method}},
  \code{\link{loopStart<-}},
  \code{\link{loopStart<-,PTSample-method}};
  \code{\link{loopState}},
  \code{\link{loopState,PTSample-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}};
  \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{volume}},
  \code{\link{volume,PTSample-method}},
  \code{\link{volume<-}},
  \code{\link{volume<-,PTSample,numeric-method}};
  \code{\link{waveform}},
  \code{\link{waveform,PTSample-method}},
  \code{\link{waveform<-}},
  \code{\link{waveform<-,PTSample-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}
}

