% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{appendPattern}
\alias{appendPattern}
\alias{appendPattern,PTModule,PTPattern-method}
\title{Append a PTPattern to a PTModule}
\usage{
\S4method{appendPattern}{PTModule,PTPattern}(x, pattern)
}
\arguments{
\item{x}{A \code{\link{PTModule}} object to which a
\code{\link{PTPattern}} is to be appended.}

\item{pattern}{A \code{\link{PTPattern}} object which is
to be appended to the \code{\link{PTModule}} \code{x}.}
}
\value{
Returns a \code{\link{PTModule}}, to which the
\code{\link{PTPattern}} is appended.
}
\description{
Appends a specified \code{\link{PTPattern}} to a
\code{\link{PTModule}}.
}
\details{
Depending on the \code{\link{trackerFlag}}, a ProTracker module can hold
either 64 or 100 pattern tables. As long as the number of pattern tables
is below this maximum, new pattern tables can be added to the module with
this function.

The \code{\link{patternOrder}} table should hold the maximum index of the
available pattern tables in a module, otherwise, the module is not valid.
As the maximum index increases, by appending a pattern table, the
\code{\link{patternOrder}} table should be updated. The
\code{\link{appendPattern}} method does this automatically, by replacing the first
non-unique index in the order table, outside the current order table's length,
with the new maximum index. If this is not possible, the highest element
in the order table is set to hold the maximum index.
}
\note{
As per ProTracker specification, the pattern indices
stored in the \code{\link{PTModule}} and obtained with
\code{\link{patternOrder}} start at 0. Whereas R starts indexing at 1.
Beware of this discrepancy.
}
\examples{
data("mod.intro")

## append an empty pattern to mod.intro

mod.intro <- appendPattern(mod.intro, new("PTPattern"))

## append a copy of pattern # 1 (this is pattern #0 in the
## patternOrder table) to mod.intro

mod.intro <- appendPattern(mod.intro, PTPattern(mod.intro, 1))

}
\author{
Pepijn de Vries
}
\seealso{
Other module.operations: \code{\link{PTModule-class}},
  \code{\link{clearSamples}}, \code{\link{clearSong}},
  \code{\link{deletePattern}}, \code{\link{fix.PTModule}},
  \code{\link{modToWave}}, \code{\link{moduleSize}},
  \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}, \code{\link{playMod}},
  \code{\link{playingtable}}, \code{\link{read.module}},
  \code{\link{trackerFlag}}, \code{\link{write.module}}

Other pattern.operations: \code{\link{PTPattern-class}},
  \code{\link{PTPattern-method}},
  \code{\link{deletePattern}}, \code{\link{pasteBlock}},
  \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}
}

