% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache}
\alias{cache}
\title{Cache a data set for faster loading.}
\usage{
cache(variable = NULL, CODE = NULL, depends = NULL, ...)
}
\arguments{
\item{variable}{A character string containing the name of the variable to
be saved.  If the CODE parameter is defined, it is evaluated and saved, otherwise
the variable with that name in the global environment is used.}

\item{CODE}{A sequence of R statements enclosed in \code{\{..\}} which produce the object to be
cached.}

\item{depends}{A character vector of other global environment objects that the CODE
depends upon. Caching will be forced if those objects have changed since last caching}

\item{...}{Additional arguments passed on to \code{\link{save}} or optionally
to \code{\link[qs]{qsave}}. See \code{\link{project.config}} for further
information.}
}
\value{
No value is returned; this function is called for its side effects.
}
\description{
This function will store a copy of the named data set in the \code{cache}
directory. This cached copy of the data set will then be given precedence
at load time when calling \code{\link{load.project}}. Cached data sets are
stored as \code{.RData} or optionally as \code{.qs} files.
}
\details{
Usually you will want to cache datasets during munging.  This can be the raw
data just loaded, or it can be the result of further processing during munge.  Either
way, it can take a while to cache large variables, so cache will only cache when it
needs to.
The \code{clear.cache("variable")} command
can be run to flush individual items from the cache.

Calling \code{cache()} with no arguments returns the current status of the cache.
}
\examples{
library('ProjectTemplate')
\dontrun{create.project('tmp-project')

setwd('tmp-project')

dataset1 <- 1:5
cache('dataset1')

setwd('..')
unlink('tmp-project')}

}
\seealso{
\code{\link[qs]{qsave}}, \code{\link{project.config}}
}
