% Generated by roxygen2 (4.0.2.9000): do not edit by hand
\name{create.project}
\alias{create.project}
\title{Create a new project.}
\usage{
create.project(project.name = "new-project", minimal = FALSE,
  dump = FALSE, merge.strategy = c("require.empty", "allow.non.conflict"))
}
\arguments{
\item{project.name}{A character vector containing the name for this new
project. Must be a valid directory name for your file system.}

\item{minimal}{A boolean value indicating whether to create a minimal
project or a full project. A minimal project contains only the
directories strictly necessary to use ProjectTemplate and does not
provide template code for profiling, unit testing or documenting your
project.}

\item{dump}{A boolean value indicating whether the entire functionality
of ProjectTemplate should be written out to flat files in the current
project.}

\item{merge.strategy}{What should happen if the target directory exists and
  is not empty?
  If \code{"force.empty"}, the target directory must be empty;
  if \code{"allow.non.conflict"}, the method succeeds if no files or
  directories with the same name exist in the target directory.}
}
\value{
No value is returned; this function is called for its side effects.
}
\description{
This function will create all of the scaffolding for a new project.
It will set up all of the relevant directories and their initial
contents. For those who only want the minimal functionality, the
\code{minimal} argument can be set to \code{TRUE} to create a subset of
ProjectTemplate's default directories. For those who want to dump
all of ProjectTemplate's functionality into a directory for extensive
customization, the \code{dump} argument can be set to \code{TRUE}.
}
\details{
If the target directory does not exist, it is created.  Otherwise,
  it can only contain files and directories allowed by the merge strategy.
}
\examples{
library('ProjectTemplate')

\dontrun{create.project('MyProject')}
}
\seealso{
\code{\link{load.project}}, \code{\link{get.project}},
  \code{\link{cache.project}}, \code{\link{show.project}}
}

