% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfasa.R
\name{p.QFASA}
\alias{p.QFASA}
\title{Computes the diet estimate for each predator in seal.mat using
either the Kullback-Leibler Distance (KL), the Aitchison Distance
(AIT) or the Chi-Square Distance (CS).}
\usage{
p.QFASA(predator.mat, prey.mat, cal.mat, dist.meas, gamma = 1,
  FC = rep(1, nrow(prey.mat)), start.val = rep(0.99999,
  nrow(prey.mat)), ext.fa)
}
\arguments{
\item{predator.mat}{matrix containing the FA signatures of the predators.}

\item{prey.mat}{matrix containing a representative FA signature
from each prey group (usually the mean). The first column must
index the prey group.}

\item{cal.mat}{matrix of calibration factors where the \emph{i} th
column is to be used with the \emph{i} th predator. If modelling is to be done without
calibration coefficients, simply pass a vector or matrix of ones.}

\item{dist.meas}{distance measure to use for estimation: 1=KL,
2=AIT or 3=CS}

\item{gamma}{parameter required for calculations using CS distance
(passed to CS.obj). Currently being set to 1.}

\item{FC}{vector of fat content}

\item{start.val}{initial vector of parameters to be optimized}

\item{ext.fa}{subset of fatty acids to be used to obtain QFASA diet estimates.}
}
\value{
a list with components:
\item{\strong{Diet Estimates}}{A matrix of the diet estimates for each predator where each row corresponds to a predator and the columns to prey species. The estimates are expressed as proportions summing to one.}
\item{\strong{Additional Measures}}{For each predator for which a diet estimate was obtained:}
\item{ModFAS}{the value of the modelled fatty acid (i.e., after CCs have been applied and the fatty acids subsetted and renormalised over the designated fatty acid set).
 These are expressed as proportions summing to one.}
\item{DistCont}{The contribution of each fatty acid to the final minimized distance.} 
\item{PropDistCont}{The contribution of each fatty acid to the final minimized distance as a proportion of the total.}
\item{MinDist}{The final minimized distance.}
}
\description{
Computes the diet estimate for each predator in seal.mat using
either the Kullback-Leibler Distance (KL), the Aitchison Distance
(AIT) or the Chi-Square Distance (CS).
}
\examples{
 ## Fatty Acids
 data(FAset)
 fa.set = as.vector(unlist(FAset))
 
 ## Predators
 data(predatorFAs)
 tombstone.info = predatorFAs[,1:4]
 predator.matrix = predatorFAs[,5:(ncol(predatorFAs))]
 npredators = nrow(predator.matrix)

 ## Prey
 data(preyFAs)
 prey.sub=(preyFAs[,4:(ncol(preyFAs))])[fa.set]
 prey.sub=prey.sub/apply(prey.sub,1,sum) 
 group=as.vector(preyFAs$Species)
 prey.matrix=cbind(group,prey.sub)
 prey.matrix=MEANmeth(prey.matrix) 

 FC = preyFAs[,c(2,3)] 
 FC = as.vector(tapply(FC$lipid,FC$Species,mean,na.rm=TRUE))

 ## Calibration Coefficients
 data(CC)
 cal.vec = CC[,2]
 cal.mat = replicate(npredators, cal.vec)

 # Run QFASA
 Q = p.QFASA(predator.matrix,
             prey.matrix,
             cal.mat,
             dist.meas = 1, 
             gamma=1,
             FC,
             start.val = rep(1,nrow(prey.matrix)),
             fa.set)
 
}
