% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QPotential.R
\name{QPotential}
\alias{QPotential}
\title{Computes the quasi-potential for a system of stochastic differential equations using the upwind ordered method.}
\usage{
QPotential(x.rhs = "NULL", x.start = "NULL", x.bound = "NULL",
  x.num.steps = "NULL", y.rhs = "NULL", y.start = "NULL",
  y.bound = "NULL", y.num.steps = "NULL", filename = "NULL",
  save.to.R = TRUE, save.to.HD = FALSE, bounce = "d",
  bounce.edge = 0.01, verboseR = FALSE, verboseC = TRUE, debugC = FALSE,
  k.x = 20, k.y = 20)
}
\arguments{
\item{x.rhs}{a string containing the right hand side of the equation for x.}

\item{x.start}{the starting value of x, usually the x value of the current equilibrium.}

\item{x.bound}{the x boundaries denoted as c(minimum, maximum).}

\item{x.num.steps}{the number of steps between the minimum and maximum x value defined in x range.}

\item{y.rhs}{a string containing the right hand side of the equation for y.}

\item{y.start}{the starting value of y, usually the y value of the current equilibrium.}

\item{y.bound}{the y boundaries denoted as c(minimum, maximum).}

\item{y.num.steps}{the number of steps between the minimum and maximum y value defined in y range.}

\item{filename}{string for the name of the file saved to the hard drive.  If save.to.HD=TRUE and filename is left blank, output file saved as defaultname-xX.STARTyY.START.txt, where X.START and Y.START are values in x.start and y.start, respectively.  Matrix stored as a tab-delimited file.}

\item{save.to.R}{boolean to output the matrix of results for the upwind-ordered method to the current R session.  The default is to write the matrix to the R session.  save.to.R=FALSE prevents the output from being written to the R session.}

\item{save.to.HD}{boolean to write the matrix of results for the upwind-ordered method to the hard drive in a file named filename.  Default is FALSE.}

\item{bounce}{by default, the upwind-ordered method stops when the boundaries are reached (x.bound and y.bound).  The bounce parameter allows the default action (bounce = 'd'), only positive values to be tested (bounce = 'p'), or reflection near the boundaries (bounce = 'b').}

\item{bounce.edge}{if bounce = 'b', then to prevent the upwind-ordered method from reaching the boundaries, temporary boundaries are created inside the boundaries defined by x.bound and y.bound.  The boundary edge is bounce.edge of the total range.  Default is 0.01}

\item{verboseR}{NOT IMPLEMENTED: Flag (default = FALSE) for printing out information in QPotential R wrapper.}

\item{verboseC}{flag (default = TRUE) for printing out useful-for-everyone information from C code implementing the upwind-ordered method (quasipotential.C).}

\item{debugC}{NOT IMPLEMENTED: Flag (default = FALSE) for printing out debugging C code}

\item{k.x}{integer anisotropic factor for x.  See journal article.  Default is 20.}

\item{k.y}{integer anisotropic factor for y.  See journal article.  Default is 20.}
}
\value{
filetoHD if save.to.HD enabled, then saves a file in the current directory as either filename or as defaultname-xXSTARTyYSTART.txt

filetoR if save.to.R enabled, then the function QPotential returns a matrix containing  the upwind-ordered results to be used for plotting.  Requires a variable to catch the returned matrix, i.e. storage <- QPotential(parameters...)
}
\description{
Computes the quasi-potential for a system of stochastic differential equations using the upwind ordered method.
}
\examples{
# First, System of equations
	equationx <- "1.54*x*(1.0-(x/10.14)) - (y*x*x)/(1.0+x*x)"
	equationy <- "((0.476*x*x*y)/(1+x*x)) - 0.112590*y*y"

# Second, shared parameters for each quasi-potential run
	xbounds <- c(-0.5, 8.0)
	ybounds <- c(-0.5, 8.0)
	xstepnumber <- 200
	ystepnumber <- 200

# Third, a local quasi-potential run
	xinit1 <- 1.40491
	yinit1 <- 2.80808
	storage.eq1 <- QPotential(x.rhs = equationx, x.start = xinit1, 
	x.bound = xbounds, x.num.steps = xstepnumber, y.rhs = equationy, 
	y.start = yinit1, y.bound = ybounds, y.num.steps = ystepnumber)
# Visualize the quasi-potential
QPContour(storage.eq1, dens = c(xstepnumber, ystepnumber), 
	x.bound = xbounds, y.bound = ybounds, c.parm = 5) 
}

