% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata-utilities.R
\name{metadata_utilities}
\alias{metadata_utilities}
\alias{regex_named_captures}
\alias{checkbox_choices}
\title{Manipulate and interpret the metadata of a REDCap project}
\usage{
regex_named_captures(pattern, text, perl = TRUE)

checkbox_choices(select_choices)
}
\arguments{
\item{pattern}{The regular expression pattern.  Required.}

\item{text}{The text to apply the regex against.  Required.}

\item{perl}{Indicates if perl-compatible regexps should be used.
Default is \code{TRUE}. Optional.}

\item{select_choices}{The text containing the choices that should be parsed
to determine the \code{id} and \code{label} values.  Required.}
}
\value{
Currently, a \code{\link[base:data.frame]{base::data.frame()}} is returned a row for each match,
and a column for each \emph{named} group within a match.  For the
\code{retrieve_checkbox_choices()} function, the columns will be.
\itemize{
\item \code{id}: The numeric value assigned to each choice (in the data dictionary).
\item \code{label}: The label assigned to each choice (in the data dictionary).
}
}
\description{
A collection of functions that assists handling REDCap
project metadata.
}
\details{
The \code{\link[=regex_named_captures]{regex_named_captures()}} function is general, and not specific to
REDCap; it accepts any arbitrary regular expression.
It returns a \code{\link[base:data.frame]{base::data.frame()}} with as many columns as named matches.

The \code{\link[=checkbox_choices]{checkbox_choices()}} function is specialized, and accommodates the
"select choices" for a \emph{single} REDCap checkbox group (where multiple boxes
can be selected).  It returns a \code{\link[base:data.frame]{base::data.frame()}} with two columns, one
for the numeric id and one for the text label.
}
\examples{
# The weird ranges are to avoid the pipe character;
#   PCRE doesn't support character negation.
pattern_boxes <- "(?<=\\\\A| \\\\| )(?<id>\\\\d{1,}), (?<label>[\x20-\x7B\x7D-\x7E]{1,})(?= \\\\| |\\\\Z)"

choices_1 <- paste0(
  "1, American Indian/Alaska Native | ",
  "2, Asian | ",
  "3, Native Hawaiian or Other Pacific Islander | ",
  "4, Black or African American | ",
  "5, White | ",
  "6, Unknown / Not Reported")

# This calls the general function, and requires the correct regex pattern.
REDCapR::regex_named_captures(pattern=pattern_boxes, text=choices_1)

# This function is designed specifically for the checkbox values.
REDCapR::checkbox_choices(select_choices=choices_1)

\dontrun{
uri         <- "https://bbmc.ouhsc.edu/redcap/api/"
token       <- "9A81268476645C4E5F03428B8AC3AA7B"

ds_metadata <- redcap_metadata_read(redcap_uri=uri, token=token)$data
choices_2   <- ds_metadata[ds_metadata$field_name=="race", "select_choices_or_calculations"]

REDCapR::regex_named_captures(pattern=pattern_boxes, text=choices_2)
}

path_3         <- system.file(package="REDCapR", "test-data/project-simple/simple-metadata.csv")
ds_metadata_3  <- read.csv(path_3)
choices_3      <- ds_metadata_3[ds_metadata_3$field_name=="race", "select_choices_or_calculations"]
REDCapR::regex_named_captures(pattern=pattern_boxes, text=choices_3)
}
\references{
See the official documentation for permissible characters in a
checkbox label.
\emph{I'm bluffing here, because I don't know where this is located.
If you know, please tell me.}
}
\author{
Will Beasley
}
