% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-event-read.R
\name{redcap_event_read}
\alias{redcap_event_read}
\title{Export Events}
\usage{
redcap_event_read(
  redcap_uri,
  token,
  verbose = TRUE,
  config_options = NULL,
  handle_httr = NULL
)
}
\arguments{
\item{redcap_uri}{The
\href{https://en.wikipedia.org/wiki/Uniform_Resource_Identifier}{uri}/url
of the REDCap server
typically formatted as "https://server.org/apps/redcap/api/".
Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  The verbose output might contain
sensitive information (\emph{e.g.} PHI), so turn this off if the output might
be visible somewhere public. Optional.}

\item{config_options}{A list of options passed to \code{\link[httr:POST]{httr::POST()}}.
See details at \code{\link[httr:httr_options]{httr::httr_options()}}. Optional.}

\item{handle_httr}{The value passed to the \code{handle} parameter of
\code{\link[httr:POST]{httr::POST()}}.
This is useful for only unconventional authentication approaches.  It
should be \code{NULL} for most institutions.  Optional.}
}
\value{
Currently, a list is returned with the following elements:
\itemize{
\item \code{data}: a \code{\link[tibble:tibble]{tibble::tibble()}} with one row per arm-event combination.  The
columns are \code{event_name} (a human-friendly string), \code{arm_num} (an integer),
\code{unique_event_name} (a string), \code{custom_event_label} (a string), and
\code{event_id} (an integer).
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_code}: The
\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status code}
of the operation.
\item \code{outcome_message}: A human readable string indicating the operation's
outcome.
\item \code{elapsed_seconds}: The duration of the function.
\item \code{raw_text}: If an operation is NOT successful, the text returned by
REDCap.  If an operation is successful, the \code{raw_text} is returned as an
empty string to save RAM.
}
}
\description{
Export Events of a REDCap project
}
\examples{
\dontrun{
uri            <- "https://bbmc.ouhsc.edu/redcap/api/"

# Query a longitudinal project with a single arm and 3 events
token_1  <- "786334BEB4A87D572DD0E99C4BFCE144"
result_1 <- REDCapR::redcap_event_read(redcap_uri=uri, token=token_1)
result_1$data

# Query a longitudinal project with 2 arms and complex arm-event mappings
token_2  <- "0434F0E9CF53ED0587847AB6E51DE762"
result_2 <- REDCapR::redcap_event_read(redcap_uri=uri, token=token_2)
result_2$data

# Query a classic project without events
token_3  <- "D70F9ACD1EDD6F151C6EA78683944E98"
result_3 <- REDCapR::redcap_event_read(redcap_uri=uri, token=token_3)
result_3$data
}
}
\references{
The official documentation can be found on the 'API Help Page'
and 'API Examples' pages on the REDCap wiki (\emph{i.e.},
https://community.projectredcap.org/articles/456/api-documentation.html and
https://community.projectredcap.org/articles/462/api-examples.html).
If you do not have an account for the wiki, please ask your campus REDCap
administrator to send you the static material.
}
\author{
Ezra Porter, Will Beasley
}
