/*
 * Decompiled with CFR 0.152.
 */
package javalain.math.fonction.simpleobjectif;

import java.util.Comparator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.ObjectiveComparator;
import javalain.math.fonction.Fct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ackley
extends Fct {
    private static final double cte = Math.PI * 2;

    public Ackley() {
        this(10);
    }

    public Ackley(int d) {
        this.nomFct = "Ackley";
        this.nbVariable = d;
        this.nbFctObjectif = 1;
        this.lowerLimit = new double[this.nbVariable];
        this.upperLimit = new double[this.nbVariable];
        for (int i = 0; i < this.nbVariable; ++i) {
            this.lowerLimit[i] = -32.768;
            this.upperLimit[i] = 32.768;
        }
    }

    @Override
    public double[] compute(double[] x) {
        ++this.nbEvaluation;
        double[] fct = new double[this.nbFctObjectif];
        double somme1 = 0.0;
        double somme2 = 0.0;
        for (int i = 0; i < this.nbVariable; ++i) {
            somme1 += x[i] * x[i];
            somme2 += Math.cos(Math.PI * 2 * x[i]);
        }
        fct[0] = 22.718281828459045 - 20.0 * Math.exp(-0.2 * Math.sqrt(somme1 / (double)this.nbVariable)) - Math.exp(somme2 / (double)this.nbVariable);
        return fct;
    }

    @Override
    public double[][] getFront() {
        if (this.front == null) {
            this.front = new double[1][this.nbVariable];
            for (int i = 0; i < this.nbVariable; ++i) {
                this.front[0][i] = 0.0;
            }
        }
        return this.front;
    }

    @Override
    public Comparator<SolutionEA> comparator() {
        return new ObjectiveComparator(0);
    }
}

