/*
 * Decompiled with CFR 0.152.
 */
package javalain.tribes;

import javalain.math.Calcul;
import javalain.math.fonction.Fct;
import util.GuiUtils;

public class ParticuleTribes {
    private static double EPS = 1.0E-14;
    private static final int AMELIORATION = 0;
    private static final int STATU_QUO = 1;
    private static final int DETERIORATION = 2;
    private static final int BONNE = 5;
    private static final int NEUTRE = 6;
    private final Fct fct;
    private final int P;
    private double perf;
    public double bestPerf;
    public double[] position;
    public double[] bestPosition;
    private int evolPerfPrec;
    private int evolPerf;
    private int qualite;

    public ParticuleTribes(Fct fct) {
        this.fct = fct;
        this.P = fct.getNbVariable();
        this.position = new double[this.P];
        this.bestPosition = new double[this.P];
        for (int i = 0; i < this.P; ++i) {
            this.position[i] = Calcul.randomDouble(this.fct.getLowerLimit(i), this.fct.getUpperLimit(i));
        }
        this.bestPerf = this.perf = -this.fct.compute(this.position)[0];
        System.arraycopy(this.position, 0, this.bestPosition, 0, this.P);
        this.evolPerfPrec = 1;
        this.evolPerf = 1;
        this.qualite = 6;
    }

    private ParticuleTribes(ParticuleTribes particule) {
        this.fct = particule.fct;
        this.P = particule.P;
        this.position = new double[this.P];
        this.bestPosition = new double[this.P];
        System.arraycopy(particule.position, 0, this.position, 0, this.P);
        System.arraycopy(particule.bestPosition, 0, this.bestPosition, 0, this.P);
        this.perf = particule.perf;
        this.bestPerf = particule.bestPerf;
        this.evolPerfPrec = particule.evolPerfPrec;
        this.evolPerf = particule.evolPerf;
        this.qualite = particule.qualite;
    }

    public ParticuleTribes(Fct ind, ParticuleTribes bestParticuleOfSwarm, ParticuleTribes bestParticuleOfTribe) {
        this.fct = ind;
        this.P = ind.getNbVariable();
        this.position = Calcul.loiHyperspherique(bestParticuleOfSwarm.bestPosition, bestParticuleOfTribe.bestPosition);
        this.fct.limite(this.position);
        this.bestPosition = new double[this.P];
        this.bestPerf = this.perf = -this.fct.compute(this.position)[0];
        System.arraycopy(this.position, 0, this.bestPosition, 0, this.P);
        this.evolPerfPrec = 1;
        this.evolPerf = 1;
        this.qualite = 6;
    }

    public boolean isGood() {
        return this.qualite == 5;
    }

    public ParticuleTribes createCopie() {
        return new ParticuleTribes(this);
    }

    public void updatePosition(ParticuleTribes informatrice) {
        if (Calcul.distanceEuclidienne(this.bestPosition, informatrice.bestPosition) < EPS) {
            return;
        }
        if (this.evolPerfPrec == 2 && this.evolPerf == 2 || this.evolPerfPrec == 1 && this.evolPerf == 2 || this.evolPerfPrec == 2 && this.evolPerf == 1 || this.evolPerfPrec == 1 && this.evolPerf == 1 || this.evolPerfPrec == 0 && this.evolPerf == 2) {
            this.pivot(informatrice);
        }
        if (this.evolPerfPrec == 0 && this.evolPerf == 1 || this.evolPerfPrec == 2 && this.evolPerf == 0) {
            this.pivotBruite(informatrice);
        }
        if (this.evolPerfPrec == 1 && this.evolPerf == 0 || this.evolPerfPrec == 0 && this.evolPerf == 0) {
            this.gaussienneIndependante(informatrice);
        }
        this.fct.limite(this.position);
    }

    public void updateBest() {
        double d = this.perf;
        this.perf = -this.fct.compute(this.position)[0];
        this.evolPerfPrec = this.evolPerf;
        this.evolPerf = Math.abs(d - this.perf) < EPS ? 1 : (this.perf > d ? 0 : 2);
        if (this.perf > this.bestPerf) {
            this.bestPerf = this.perf;
            System.arraycopy(this.position, 0, this.bestPosition, 0, this.P);
            this.qualite = 5;
        } else {
            this.qualite = 6;
        }
    }

    private void pivot(ParticuleTribes informatrice) {
        double somme = this.bestPerf + informatrice.bestPerf;
        double c2 = somme < EPS ? Math.random() : this.bestPerf / somme;
        double c3 = 1.0 - c2;
        double[] alea_Hp = Calcul.loiHyperspherique(this.bestPosition, informatrice.bestPosition);
        double[] alea_Hg = Calcul.loiHyperspherique(informatrice.bestPosition, this.bestPosition);
        for (int i = 0; i < this.P; ++i) {
            this.position[i] = c2 * alea_Hp[i] + c3 * alea_Hg[i];
        }
    }

    private void pivotBruite(ParticuleTribes informatrice) {
        double somme = this.bestPerf + informatrice.bestPerf;
        double c2 = somme < EPS ? Math.random() : this.bestPerf / somme;
        double c3 = 1.0 - c2;
        double[] alea_Hp = Calcul.loiHyperspherique(this.bestPosition, informatrice.bestPosition);
        double[] alea_Hg = Calcul.loiHyperspherique(informatrice.bestPosition, this.bestPosition);
        for (int i = 0; i < this.P; ++i) {
            this.position[i] = c2 * alea_Hp[i] + c3 * alea_Hg[i];
        }
        double sigma = somme < EPS ? 1.0 : (this.bestPerf - informatrice.bestPerf) / somme;
        double c = Calcul.loiNormale(0.0, sigma);
        for (int i = 0; i < this.P; ++i) {
            this.position[i] = (1.0 + c) * this.position[i];
        }
    }

    private void gaussienneIndependante(ParticuleTribes informatrice) {
        for (int i = 0; i < this.P; ++i) {
            double d = informatrice.bestPosition[i] - this.position[i];
            double sigma = Math.abs(informatrice.bestPosition[i] - this.position[i]);
            this.position[i] = this.bestPosition[i] + Calcul.loiNormale(d, sigma);
        }
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append("----- Particule (").append(this.P).append(")\n");
        s.append("Perf             : ").append(GuiUtils.DECIMAL_12.format(this.perf)).append("\n");
        s.append("Best perf        : ").append(GuiUtils.DECIMAL_12.format(this.bestPerf)).append("\n");
        s.append("Position         : ");
        for (i = 0; i < this.P - 1; ++i) {
            s.append(GuiUtils.DECIMAL_12.format(this.position[i])).append(", ");
        }
        s.append(GuiUtils.DECIMAL_12.format(this.position[this.P - 1])).append("\n");
        s.append("Best position    : ");
        for (i = 0; i < this.P - 1; ++i) {
            s.append(GuiUtils.DECIMAL_12.format(this.bestPosition[i])).append(", ");
        }
        s.append(GuiUtils.DECIMAL_12.format(this.bestPosition[this.P - 1])).append("\n");
        s.append("-----");
        return s.toString();
    }
}

